#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType
from CliPlugin.TrafficPolicyCliLib import ReservedClassMapNames
from CliPlugin.SamplePolicyCliLib import ( SamplePolicyContext,
                                           SamplePolicyMatchRuleContext )
from CliMode.PostcardTelemetry import ( PostcardSamplePolicyConfigMode,
                                        PostcardSamplePolicyMatchRuleIpv4ConfigMode,
                                        PostcardSamplePolicyMatchRuleIpv6ConfigMode,
                                        PostcardSamplePolicyActionRuleConfigMode )

tacMatchOption = TacLazyType( 'PolicyMap::ClassMapMatchOption' )
matchIpAccessGroup = tacMatchOption.matchIpAccessGroup
matchIpv6AccessGroup = tacMatchOption.matchIpv6AccessGroup

class PostcardSamplePolicyMatchRuleContext( SamplePolicyMatchRuleContext ):
   def childMode( self, matchRuleName, matchOption ):
      if matchOption == matchIpAccessGroup:
         return PostcardSamplePolicyMatchRuleIpv4ConfigMode
      else:
         assert matchOption == matchIpv6AccessGroup
         return PostcardSamplePolicyMatchRuleIpv6ConfigMode

   def actionMode( self ):
      return PostcardSamplePolicyActionRuleConfigMode

class PostcardSamplePolicyContext( SamplePolicyContext ):
   def childMode( self ):
      return PostcardSamplePolicyConfigMode

   def reservedClassMapNames( self ):
      classMapNames = [ ReservedClassMapNames.classV4Default,
                        ReservedClassMapNames.classV6Default ]
      return classMapNames
