#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliPlugin.PowerCli as PowerCli # pylint: disable=consider-using-from-import
from CliPlugin.ThermoMgrGlobalConfigMode import ( matcherEnvironment,
                                                  matcherInterval,
                                                  matcherPollInterval,
                                                  matcherMilliseconds,
                                                  matcherSeconds )
from CliMatcher import FloatMatcher

#--------------------------------------------------------------------------------
# [ no | default ] power poll-interval INTERVAL
#--------------------------------------------------------------------------------
class PowerPollIntervalCmd( CliCommand.CliCommandClass ):
   syntax = 'power poll-interval INTERVAL [ seconds | milliseconds ]'
   noOrDefaultSyntax = 'power poll-interval ...'
   data = {
      'power': 'Configure power supplies',
      'poll-interval': 'Configure Pmbus/Psmi and fixed power supply poll interval',
      'INTERVAL': matcherInterval,
      'seconds' : matcherSeconds,
      'milliseconds': matcherMilliseconds,
   }
   handler = PowerCli.pollInterval
   noOrDefaultHandler = handler

BasicCliModes.GlobalConfigMode.addCommandClass( PowerPollIntervalCmd )

#--------------------------------------------------------------------------------
# [ no | default ] environment power controller poll-interval
#--------------------------------------------------------------------------------
class PowerControllerPollIntervalCmd( CliCommand.CliCommandClass ):
   syntax = ( "environment power controller poll-interval "
              "INTERVAL ( seconds | milliseconds )" )
   noOrDefaultSyntax = "environment power controller poll-interval ..."
   data = {
      'environment' : matcherEnvironment,
      'power' : 'Configure the system behavior for power',
      'controller' : 'Configure the system behavior for power controllers',
      'poll-interval' : matcherPollInterval,
      'INTERVAL' : matcherInterval,
      'seconds' : matcherSeconds,
      'milliseconds' : matcherMilliseconds,
   }

   handler = PowerCli.setPowerControllerPollInterval
   noOrDefaultHandler = PowerCli.setPowerControllerPollInterval

BasicCliModes.GlobalConfigMode.addCommandClass( PowerControllerPollIntervalCmd )

#--------------------------------------------------------------------------------
# [ no | default ] power limit current NUM_AMPS amps
#--------------------------------------------------------------------------------
class PowerLimitCurrentCmd( CliCommand.CliCommandClass ):
   syntax = 'power limit current NUM_AMPS amps'
   noOrDefaultSyntax = 'power limit current ...'
   data = {
      'power': 'Configure power supplies',
      'limit': 'Configure the max limit for power supply',
      'current': 'Configure the max input current',
      'NUM_AMPS': FloatMatcher( 0, 100, helpdesc='Number of amps',
                                precisionString='%.1f' ),
      'amps': 'Unit amps',
   }
   handler = PowerCli.setPowerLimitCurrent
   noOrDefaultHandler = handler

BasicCliModes.GlobalConfigMode.addCommandClass( PowerLimitCurrentCmd )

#--------------------------------------------------------------------------------
# [ no | default ] power redundancy cold
#--------------------------------------------------------------------------------
class PowerRedundancyColdCmd( CliCommand.CliCommandClass ):
   syntax = 'power redundancy cold'
   noOrDefaultSyntax = syntax
   data = {
      'power': 'Configure power supplies',
      'redundancy': 'Configure redundancy for power supply',
      'cold': 'Configure power supply turn off to increase efficiency',
   }
   handler = PowerCli.enablePowerRedundancyCold
   noOrDefaultHandler = PowerCli.disablePowerRedundancyCold
   hidden = True

BasicCliModes.GlobalConfigMode.addCommandClass( PowerRedundancyColdCmd )
