#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
from CliPlugin.ThermoMgrGlobalConfigMode import matcherEnvironment
import ConfigMount

ledCliConfig = None

#------------------------------------------------------
# [ no | default ] environment power save led auto-off
#------------------------------------------------------
class LedAutoOffCmd( CliCommand.CliCommandClass ):
   syntax = 'environment power save led auto-off'
   noOrDefaultSyntax = syntax
   data = {
      'environment' : matcherEnvironment,
      'power' : 'Configure the system behavior for power',
      'save' : 'Configure power saving features',
      'led' : 'Interface LEDs',
      'auto-off' : 'Turning off LEDs if no change on front panel ports',
   }

   @staticmethod
   def handler( mode, args ):
      ledCliConfig.powerSaving = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ledCliConfig.powerSaving = False

BasicCliModes.GlobalConfigMode.addCommandClass( LedAutoOffCmd )

def Plugin( entityManager ):
   global ledCliConfig
   ledCliConfig = ConfigMount.mount( entityManager, "hardware/led/cli/config",
                                     "Hardware::Led::LedCliConfig", "w" )
