#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import IntfCli
import Tac, ConfigMount, Tracing

__defaultTraceHandle__ = Tracing.Handle( 'PtpCli' )
t8 = Tracing.trace8

ptpConfig = None

class PtpIntfJanitor( IntfCli.IntfDependentBase ):
   def setDefault( self ):
      '''(config) default interface <intf> handler
      '''
      del ptpConfig.intfConfig[ self.intf_.name ]
      defaultedPortDSKeys = [ k for k in ptpConfig.intfRegionConfig.keys()
                              if k.intf == self.intf_.name ]
      for key in defaultedPortDSKeys:
         del ptpConfig.intfRegionConfig[ key ]


def Plugin( entityManager ):
   global ptpConfig
   ptpConfig = ConfigMount.mount( entityManager, "ptp/config", "Ptp::Config", "w" )
   IntfCli.Intf.registerDependentClass( PtpIntfJanitor, priority=10 )
