# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import CliParser
import CliPlugin.ConfigConvert
import CliPlugin.TechSupportCli
from CliPlugin.IntfCli import IntfConfigMode
import ConfigMount
import LazyMount
import Plugins
from QosLib import *  # pylint: disable-msg=W0401
from QosTypes import ( tacActionRateType, tacActionType, tacBurstUnit, tacBwWeight,
                      tacClassMapCpType, tacCos, tacCosToTcProfileName,
                      tacExpToTcProfileName, tacDropPrecedence, tacDscp,
                      tacEcnDelayThreshold, tacExp, tacGuaranteedBwUnit,
                      tacGuaranteedBwVal, tacMatchOption, tacPercent,
                      tacQueueThresholdUnit, tacQueueType, tacQueueWeight,
                      tacRateUnit, tacShapeRateUnit, tacShapeRateVal,
                      tacTcToCosMapName, tacTrafficClass, tacTrustMode,
                      tacTxQueuePriority, tacSchedulerCompensation,
                      tacPolicerPktSizeAdjProfileName, tacPolicerPktSizeAdj,
                      tacDei )

# -----------------------------------------------------------------------------------
# The Qos globals
# -----------------------------------------------------------------------------------
qosHwStatus = None
qosInputConfig = None
subIntfHwStatus = None

# -----------------------------------------------------------------------------------
# The Qos tokens
# -----------------------------------------------------------------------------------
def guardQos( mode, token ):
   if qosHwStatus.hwInitialized:
      return None
   return CliParser.guardNotThisPlatform

def guardExpToTcPerInterface( mode, token ):
   if not qosHwStatus.expToTcPerInterfaceSupported:
      return CliParser.guardNotThisPlatform
   return None

def guardExpToTcSupported( mode, token ):
   if guardExpToTcPerInterface( mode, token ):
      return CliParser.guardNotThisPlatform
   return None

def guardTcToCosPerInterface( mode, token ):
   if not qosHwStatus.tcToCosPerInterfaceSupported:
      return CliParser.guardNotThisPlatform
   return None

def guardCpuTcToCosPerInterface( mode, token ):
   if isinstance( mode, IntfConfigMode ):
      if isLagPort( mode.intf.name ):
         if qosHwStatus.cpuTcToCosPerLagSupported:
            return None
         else:
            return CliParser.guardNotThisPlatform
      elif mode.intf.isSubIntf():
         if qosHwStatus.cpuTcToCosPerSubInterfaceSupported:
            return None
         else:
            return CliParser.guardNotThisPlatform
      else:
         if qosHwStatus.cpuTcToCosPerInterfaceSupported:
            return None
         else:
            return CliParser.guardNotThisPlatform

   if not qosHwStatus.cpuTcToCosPerSubInterfaceSupported and \
      not qosHwStatus.cpuTcToCosPerInterfaceSupported and \
      not qosHwStatus.cpuTcToCosPerLagSupported:
      return CliParser.guardNotThisPlatform
   else:
      return None

def guardAnyTcToCosPerInterface( mode, token ):
   if guardTcToCosPerInterface( mode, token ) and \
      guardCpuTcToCosPerInterface( mode, token ):
      return CliParser.guardNotThisPlatform
   return None


nodeQosForShow = CliCommand.guardedKeyword( 'qos',
      helpdesc='Show QoS status', guard=guardQos )
nodeQosForConfig = CliCommand.guardedKeyword( 'qos',
      helpdesc='Configure QoS parameters', guard=guardQos )
matcherMap = CliMatcher.KeywordMatcher( 'map',
      helpdesc='Mapping configuration of different QoS parameters' )
tokenTrafficClassHelpdesc = 'Mapping traffic-class values'
tcToCosMapNameRule = CliMatcher.DynamicNameMatcher(
         lambda mode:qosInputConfig.tcToCosNamedMap, 'Map Name',
         pattern=r'(?!default-map$)[A-Za-z0-9_:{}\[\]-]+' )
tokenTcToCosMapTo = CliCommand.guardedKeyword( 'to',
      helpdesc="Configure a named Map", guard=guardAnyTcToCosPerInterface )
MapToCosHelpdesc = 'Map to Cos'

# --------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# --------------------------------------------------------------------------------
@Plugins.plugin( provides=( "QosCli", ) )
def Plugin( entityManager ):
   global qosInputConfig, qosHwStatus, subIntfHwStatus

   qosInputConfig = ConfigMount.mount( entityManager, "qos/input/config/cli",
                                       "Qos::Input::Config", "w" )
   qosHwStatus = LazyMount.mount( entityManager, "qos/hardware/status/global",
                                  "Qos::HwStatus", "r" )

   subIntfHwStatus = LazyMount.mount( entityManager, "interface/hardware/capability",
                                      "Interface::Hardware::Capability", "r" )

   # --------------------------------------------------------------------------------
   # Register commands to show tech-support
   # --------------------------------------------------------------------------------
   CliPlugin.TechSupportCli.registerShowTechSupportCmd(
      '2019-12-04 16:19:43',
      cmds=[ 'show qos maps' ],
      cmdsGuard=lambda: qosHwStatus.hwInitialized )
   CliPlugin.TechSupportCli.registerShowTechSupportCmd(
      '2021-06-23 17:03:16',
      cmds=[ 'show qos scheduling group' ],
      cmdsGuard=lambda: qosHwStatus.hwInitialized and
      subIntfHwStatus.subIntfSchedulingGroupSupported )
