#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import ( EthIntfCli, FabricIntfCli, LagIntfCli, SwitchIntfCli,
                        VlanIntfCli )

ethIntfTypes = (
   EthIntfCli.EthPhyAutoIntfType,
   SwitchIntfCli.SwitchAutoIntfType,
)
ethOrLagIntfTypes = ethIntfTypes + (
   LagIntfCli.LagAutoIntfType,
)
ethOrLagOrVlanIntfTypes = ethOrLagIntfTypes + (
   VlanIntfCli.VlanAutoIntfType,
)
ethOrLagOrFabricIntfTypes = ethOrLagIntfTypes + (
   FabricIntfCli.FabricIntfRangePlugin.fabricAutoIntfType,
)
ethIntfPrefixes = tuple( x.tagLong for x in ethIntfTypes )
ethOrLagIntfPrefixes = tuple( x.tagLong for x in ethOrLagIntfTypes )
ethOrLagOrVlanIntfPrefixes = tuple( x.tagLong for x in ethOrLagOrVlanIntfTypes )
ethOrLagOrFabricIntfPrefixes = tuple( x.tagLong for x in ethOrLagOrFabricIntfTypes )
