#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCliModes import GlobalConfigMode
import CliCommand
import CliMatcher
import LazyMount
import Plugins
from CliPlugin import ( QosCli )
from CliPlugin.QosCliCommon import ( guardShapedLagSubIntfLoadbalance )

# -----------------------------------------------------------------------------------
# Variables for Qos GlobalConfigMode associated mount paths from Sysdb
# -----------------------------------------------------------------------------------
qosHwStatus = None

# -----------------------------------------------------------------------------------
# Guards
# -----------------------------------------------------------------------------------

# -----------------------------------------------------------------------------------
# Matchers
# -----------------------------------------------------------------------------------
matcherMlsGlobal = CliMatcher.KeywordMatcher( 'mls',
      helpdesc='MLS global commands' )
matcherMapTrafficClass = CliMatcher.KeywordMatcher( 'traffic-class',
      helpdesc='Mapping traffic-class values' )
nodeMlsGlobal = CliCommand.Node( matcher=matcherMlsGlobal, hidden=True )

# --------------------------------------------------------------------------------
# [ no | default ] qos subinterface port-channel rebalancing
# --------------------------------------------------------------------------------
class LagSubIntfRebalanceCmd( CliCommand.CliCommandClass ):
   syntax = 'qos subinterface port-channel rebalancing'
   noOrDefaultSyntax = syntax
   data = {
      'qos': QosCli.nodeQosForConfig,
      'subinterface': 'Configure subinterface parameters',
      'port-channel': 'Configure port-channel parameters',
      'rebalancing': 'Rebalance the anchor interface assignment',
   }
   handler = 'QosGlobalConfigModeHandler.enableLagSubIntfRebalance'
   defaultHandler = handler
   noHandler = 'QosGlobalConfigModeHandler.disableLagSubIntfRebalance'


GlobalConfigMode.addCommandClass( LagSubIntfRebalanceCmd )

# --------------------------------------------------------------------------------
# [ no | default ] qos subinterface port-channel load-balancing
# --------------------------------------------------------------------------------
class LagSubIntfLoadbalanceCmd( CliCommand.CliCommandClass ):
   syntax = 'qos subinterface port-channel load-balancing'
   noOrDefaultSyntax = syntax
   data = {
      'qos': QosCli.nodeQosForConfig,
      'subinterface': 'Configure subinterface parameters',
      'port-channel': 'Configure port-channel parameters',
      'load-balancing': CliCommand.guardedKeyword( 'load-balancing',
                            helpdesc='Enable port-chanel subinterface '
                            'load-balaning',
                            guard=guardShapedLagSubIntfLoadbalance ),
   }
   handler = 'QosGlobalConfigModeHandler.enableLagSubIntfLoadbalance'
   noOrDefaultHandler = 'QosGlobalConfigModeHandler.disableLagSubIntfLoadbalance'


GlobalConfigMode.addCommandClass( LagSubIntfLoadbalanceCmd )

@Plugins.plugin( provides=( "QosGlobalConfigMode", ) )
def Plugin( entityManager ):
   global qosHwStatus
   qosHwStatus = LazyMount.mount( entityManager, "qos/hardware/status/global",
                                  "Qos::HwStatus", "r" )
