# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import ShowCommand
from CliPlugin import FabricConfigCli
from CliPlugin.QosCliIntfTypes import ( ethOrLagOrVlanIntfTypes,
                                        ethOrLagIntfTypes )
from CliPlugin.LagCommonCliLib import portChannelNodeForShow
from CliPlugin.QosCliCommon import ( matcherIntf, matcherInterfaces, nodeMls,
                                     QosProfileMode,
                                     guardShapedLagSubIntfLoadbalance,
                                     nodeInterfacesStandbyGuard,
                                     guardTxQueueSchedulerProfileCustom )
from CliPlugin.QosCliModel import ( FabricAllQosAllModel,
                                   GlobalQosMapsModel, IntfAllQosAllModel,
                                   LagSubIntfLoadbalancingModel,
                                   TxQueueShapeRateAdaptiveModel,
                                   SchedulerProfileRecapModel )
from CliPlugin.QosCli import nodeQosForShow
from Intf.IntfRange import IntfRangeMatcher

matcherDscpPreserveIntf = IntfRangeMatcher(
                           explicitIntfTypes=ethOrLagOrVlanIntfTypes )
nodeFabric = CliCommand.guardedKeyword( 'fabric', "Fabric interface",
      guard=FabricConfigCli.isConfigurableFabricSystem )

# --------------------------------------------------------------------------------
# -----------------------------------------------------------------
# The show command in 'config-qos-profile' mode
#
#              show active|pending|diff
# -----------------------------------------------------------------
class QosProfileModeShowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ( pending | active | diff )'
   data = {
      'pending': 'Display the new qos profile configuration to be applied',
      'active': 'Display the current qos profile configuration',
      'diff': ( 'Display the diff between the current qos profile config and '
          'to be applied' ),
   }

   handler = 'QosShowCommandsHandler.qosProfileModeShowCmdHandler'


QosProfileMode.addShowCommandClass( QosProfileModeShowCmd )

# --------------------------------------------------------------------------------
# show [ mls ] qos interfaces [ INTF ]
# --------------------------------------------------------------------------------
class QosInterfacesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show [ mls ] qos interfaces [ INTF ]'
   data = {
      'mls': nodeMls,
      'qos': nodeQosForShow,
      'interfaces': nodeInterfacesStandbyGuard,
      'INTF': matcherIntf,
   }

   handler = 'QosShowCommandsHandler.showInterfacesQos'
   cliModel = IntfAllQosAllModel


BasicCli.addShowCommandClass( QosInterfacesCmd )

# --------------------------------------------------------------------------------
# show qos interfaces fabric [ detail ]
# --------------------------------------------------------------------------------
class QosInterfacesFabricCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show qos interfaces fabric [ detail ]'
   data = {
      'qos': nodeQosForShow,
      'interfaces': matcherInterfaces,
      'fabric': nodeFabric,
      'detail': 'More comprehensive output',
   }

   handler = 'QosShowCommandsHandler.showInterfacesQos'
   cliModel = FabricAllQosAllModel


BasicCli.addShowCommandClass( QosInterfacesFabricCmd )

# --------------------------------------------------------------------------------
# show [ mls ] qos maps
# --------------------------------------------------------------------------------
class QosMapsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show [ mls ] qos maps'
   data = {
      'mls': nodeMls,
      'qos': nodeQosForShow,
      'maps': 'Show various QoS mappings',
   }

   handler = 'QosShowCommandsHandler.showQosMaps'
   cliModel = GlobalQosMapsModel


BasicCli.addShowCommandClass( QosMapsCmd )

# --------------------------------------------------------------------------------
# show qos subinterface port-channel load-balancing
# --------------------------------------------------------------------------------
class QosLagSubIntfLoadbalancingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show qos subinterface port-channel load-balancing'
   data = {
      'qos': nodeQosForShow,
      'subinterface': "Subinterface info",
      'port-channel': portChannelNodeForShow,
      'load-balancing': CliCommand.guardedKeyword( 'load-balancing',
         "Show load-balancing information",
         guard=guardShapedLagSubIntfLoadbalance ),
   }

   handler = 'QosShowCommandsHandler.showLagSubIntfLoadbalancing'
   cliModel = LagSubIntfLoadbalancingModel


BasicCli.addShowCommandClass( QosLagSubIntfLoadbalancingCmd )

# --------------------------------------------------------------------------------
# show qos tx-queue
# --------------------------------------------------------------------------------

class TxQueueShapeRateAdaptiveCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show qos tx-queue'
   data = {
      'qos': nodeQosForShow,
      'tx-queue': 'Show transmit queue global configuration'
      }

   handler = 'QosShowCommandsHandler.showTxQueueShapeRateAdaptive'
   cliModel = TxQueueShapeRateAdaptiveModel


BasicCli.addShowCommandClass( TxQueueShapeRateAdaptiveCmd )

#--------------------------------------------------------------------------------
# show qos interfaces [ INTF ] scheduler profile
#--------------------------------------------------------------------------------
class ShowInterfaceSchedulerProfile( ShowCommand.ShowCliCommandClass ):
   syntax = 'show qos interfaces [ INTF ] scheduler profile'
   data = {
      'qos' : nodeQosForShow,
      'interfaces': matcherInterfaces,
      'INTF': IntfRangeMatcher( explicitIntfTypes=ethOrLagIntfTypes ),
      'scheduler' : CliCommand.guardedKeyword( 'scheduler',
               helpdesc='Show scheduler parameters',
               guard=guardTxQueueSchedulerProfileCustom ),
      'profile' : 'Show scheduler profile',
   }

   handler = 'QosShowCommandsHandler.showInterfaceSchedulerProfile'
   cliModel = SchedulerProfileRecapModel

BasicCli.addShowCommandClass( ShowInterfaceSchedulerProfile )
