# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Dict, Enum, Model, Str
from TableOutput import createTable, Format

class PcrQuote( Model ):
   registers = Dict( keyType=int, valueType=str,
                     help=( "A mapping of TPM Platform Configuration Register "
                            "index to its value (a hexadecimal string)" ) )
   tpmVersion = Enum( values=( "1.2", "2.0" ), help="TPM version" )
   quoteInfo = Str( help="Quote info in base64 format" )
   quoteData = Str( help="Quote data in base64 format" )
   aikCert = Str( help="AIK certificate" )

   def render( self ):
      print( "TPM version: %s" % self.tpmVersion )
      t = createTable( ( "PCR", "Value" ), indent=0 )
      f = Format( justify="left" )
      f.noPadLeftIs( True )
      f.padLimitIs( True )
      t.formatColumns( f, f )
      for v in sorted( self.registers ):
         t.newRow( str( v ), self.registers[ v ] )
      print( t.output() )
      print( "Quote info: %s" % self.quoteInfo )
      print( "Quote data: %s" % self.quoteData )
      print( "AIK certificate: %s" % self.aikCert )
