# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentDirectory
import CliPlugin.TechSupportCli
import LazyMount

entityManager = None
rfc2544HwCapabilities = None

def _showTechGuard():
   return AgentDirectory.agent( entityManager.sysname(), 'Eoam' )

def _throughputGuard():
   return ( _showTechGuard() and
            rfc2544HwCapabilities and
            rfc2544HwCapabilities.rfc2544InitiatorSupported )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2022-03-15 17:03:11',
   cmds=[ 'show monitor rfc2544 generators test-report detailed',
        ],
   cmdsGuard=_throughputGuard )

def Plugin( em ):
   global entityManager
   global rfc2544HwCapabilities
   entityManager = em

   rfc2544HwCapabilities = LazyMount.mount(
      entityManager, 'rfc2544Initiator/hardware/capabilities',
      'Rfc2544Initiator::HwCapabilities', 'r' )
