# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
from CliPlugin import LagCli
from CliPlugin import LagCliLib
import LazyMount
import Tracing

traceHandle = Tracing.Handle( 'RecircCli' )
t0 = traceHandle.trace0

# Globals written by the Plugin function at the end of this file
lagIntfConfigDir = None
recircFeatureStatus = None

isRecirc = LagCliLib.isRecirc

#-------------------------------------------------------------------------------
# Rule to match the token <recircChannelGroup_id list>, returning a list of
# corresponding RecircChannelGroup objects.
#-------------------------------------------------------------------------------

def recircChannelGroups( match ):
   # match is idList
   return list( map( LagCli.RecircChannelGroup, match ) )

#-------------------------------------------------------------------------------
# The "show recirc-channel" command, in "enable" mode.
#
# The full syntax of this command is:
#
#   show recirc-channel <recircChannelGroupIdList> [ active-ports |
#                                                    all-ports |
#                                                    brief |
#                                                    detailed |
#                                                    traffic |
#                                                    <RecircChannelGroupID> ]
#-------------------------------------------------------------------------------

def recircChannelList( mode, recircChannelGroupId ):
   return LagCliLib.portchannelList( mode, recircChannelGroupId, lacpOnly=False,
                                     filterFunc=isRecirc )

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global lagIntfConfigDir, recircFeatureStatus

   lagIntfConfigDir = ConfigMount.mount( entityManager, "interface/config/eth/lag",
                                       "Interface::EthLagIntfConfigDir", "w" )
   recircFeatureStatus = LazyMount.mount( entityManager, "lag/recirc/status",
                                          "Lag::Recirc::RecircFeatureStatus", "r" )
