#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import BasicCliModes
import CliCommand
import CliPlugin.RedSupCli as RedSupCli # pylint: disable=consider-using-from-import
# pylint: disable-next=consider-using-from-import
import CliPlugin.SupeSessionCli as SupeSessionCli
import CliToken.Redundancy as Redundancy # pylint: disable=consider-using-from-import
from CliMatcher import KeywordMatcher, StringMatcher
import ShowCommand

sessionMatcher = 'Start a CLI session'
peerSupeMatcher = CliCommand.Node( KeywordMatcher( 'peer-supervisor',
                  helpdesc='Start CLI session on the peer supervisor' ),
                  guard=RedSupCli.supervisorRedundancyGuard )

#--------------------------------------------------------------------------------
# redundancy force switchover - deprecated command
# redundancy manual switchover
#--------------------------------------------------------------------------------
class RedundancySwitchoverCmd( CliCommand.CliCommandClass ):
   syntax = 'redundancy ( force-switchover | ( manual switchover [ force ] ) )'
   data = {
      'redundancy': Redundancy.redundancyForExecGuarded,
      'force-switchover': CliCommand.Node( KeywordMatcher( 'force-switchover',
         helpdesc='Force a manual switchover' ),
         deprecatedByCmd='redundancy manual switchover' ),
      'manual': 'Manual commands',
      'switchover': 'Perform manual switchover',
      'force': CliCommand.Node( KeywordMatcher( 'force',
         helpdesc='Force a manual switchover' ),
         hidden=True )
   }
   handler = RedSupCli.doRedForceSwitchover

BasicCliModes.EnableMode.addCommandClass( RedundancySwitchoverCmd )

#--------------------------------------------------------------------------------
# session peer-supervisor
#--------------------------------------------------------------------------------
class SessionPeerSupervisorCmd( CliCommand.CliCommandClass ):
   syntax = 'session peer-supervisor'
   data = {
      'session': sessionMatcher,
      'peer-supervisor': peerSupeMatcher,
   }
   handler = SupeSessionCli.runCliOnPeerSupe

BasicCliModes.EnableMode.addCommandClass( SessionPeerSupervisorCmd )

#--------------------------------------------------------------------------------
# session peer-supervisor CMD
#--------------------------------------------------------------------------------
class SessionPeerSupervisorWithCommandCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'session peer-supervisor CMD'

   data = {
      'session': sessionMatcher,
      'peer-supervisor': peerSupeMatcher,
      'CMD': StringMatcher( helpname='COMMAND',
         helpdesc='Command to be run' ),
   }
   privileged = True
   handler = SupeSessionCli.runCliCmdOnPeerSupe
   cliModel = SupeSessionCli.PeerSupeCliCmdModel

BasicCli.addShowCommandClass( SessionPeerSupervisorWithCommandCmd )
