#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliPlugin.RedSupCli as RedSupCli # pylint: disable=consider-using-from-import
import CliToken.Redundancy as Redundancy # pylint: disable=consider-using-from-import

#--------------------------------------------------------------------------------
# redundancy
# Always register the redundancy config mode so we can parse the command
# in startup-config. The guard on redundancy should make sure it's not
# usable on fixed-systems.
#--------------------------------------------------------------------------------
class RedundancyCmd( CliCommand.CliCommandClass ):
   syntax = 'redundancy'
   noOrDefaultSyntax = syntax
   data = {
      'redundancy': Redundancy.redundancyForGlobalConfigGuarded,
   }
   handler = RedSupCli.gotoRedundancyMode

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      # cannot pass "args" directly to the command handlers.
      RedSupCli.setRedundancyProtocol( mode, {} )
      RedSupCli.noFileReplicationMode( mode, {} )
      RedSupCli.defaultStageCompletionTimeout( mode, {} )

BasicCliModes.GlobalConfigMode.addCommandClass( RedundancyCmd )
