# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import string
import LazyMount
from Hexdump import hexdump
from Toggles.ReloadCauseToggleLib import toggleMultiSourceReloadCauseEnabled

reloadCauseDebugFile = "/var/tmp/reloadCauseDebugFile"
panicBreadCrumbsFile = "/var/tmp/kernelPanicBreadCrumbs"

# By default display last 2000 lines to display from debug info file
numLines = 2000

def debugFileLines( full=False, path=reloadCauseDebugFile ):
   """
   Read a text or binary debug info file and return its contents as a list of lines.

   full <bool> -- whether to return the full debug info file contents
   path  <str> -- path to the debug file to read (default: reloadCauseDebugFile)
   """
   base = 0 if full else -numLines
   if not os.path.exists( path ):
      return []

   with open( path, 'rb' ) as f:
      contents = f.read()

   if not contents:
      return []

   # `printable` set needs to be a set of integers rather than a string to enable
   # comparison with the bytes iterable
   printable = { ord( c ) for c in string.printable }
   if any( c not in printable for c in contents ):
      return hexdump( contents, condense=False, xxd=True ).splitlines()[ base : ]

   # If our file is not a binary file, we decode it back to utf-8 text
   return [ line.decode( 'utf-8' ) for line in contents.splitlines()[ base : ] ]

def usingMSRC( em ):
   config = LazyMount.mount(
      em,
      'sys/reload/config',
      'System::ReloadCauseConfig',
      'r' )
   # `usesMultiSourceReloadCause` can be set to true in the FDL for a particular
   # product if they would like to make use of Multi-source reload cause before it is
   # turned on for all products with the MultiSourceReloadCause feature toggle.
   return toggleMultiSourceReloadCauseEnabled() or config.usesMultiSourceReloadCause
