#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
import Url
# pylint: disable-next=consider-using-from-import
import CliPlugin.VersionCompatibilityCli as VersionCompatibilityCli

#--------------------------------------------------------------------------------
# show version compatibility SWI
#--------------------------------------------------------------------------------
class VersionCompatibilityCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show version compatibility SWI'
   data = {
      'version': 'Software and hardware versions',
      'compatibility': 'Check software image version compatibility',
      'SWI' : Url.UrlMatcher(
         fsFunc=lambda fs: fs.scheme in [ 'file:', 'flash:' ],
         helpdesc='Software image URL', allowAllPaths=True ),
   }
   handler = VersionCompatibilityCli.showVersionCompatibility
   cliModel = VersionCompatibilityCli.VersionCompatibility

BasicCli.addShowCommandClass( VersionCompatibilityCmd )
