# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#------------------------------------------------------------------------------------
# This module provides Rib ipv6 cli functions that depend on cliribd.
#------------------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function
import BasicCli
import CliMatcher
import CliCommand
from CliPlugin import IraIp6Cli
from CliPlugin import IraRouteCommon
from CliToken import Ipv6
import LazyMount
from ShowCommand import ShowCliCommandClass

l3Config = None

ip = IraRouteCommon.Ip6()
routing = IraRouteCommon.routing( ip )
tagDeprecatedMatcher = CliCommand.Node(
                           CliMatcher.KeywordMatcher( 'tag', helpdesc='Route tag' ),
                           deprecatedByCmd='show ipv6 route match tag' )

class ShowIpv6RouteTag( ShowCliCommandClass ):
   syntax = "show ipv6 route [ VRF ] ( PREFIX | ADDR ) tag"
   data = {
           "ipv6": Ipv6.ipv6MatcherForShow,
           "route": IraIp6Cli.routeAfterShowIpv6Matcher,
           "VRF": IraIp6Cli.showRouteVrfNameExprFactory,
           "PREFIX": IraIp6Cli.ipv6PrefixMatcher,
           "ADDR": IraIp6Cli.ipv6AddrMatcher,
           "tag": tagDeprecatedMatcher
          }

   handler = "RibIp6CliHandler.showRouteTag"

BasicCli.addShowCommandClass( ShowIpv6RouteTag )

matchMatcher = CliMatcher.KeywordMatcher( 'match', helpdesc='Route tag' )
tagMatcher = CliMatcher.KeywordMatcher( 'tag', helpdesc='Route tag' )

class ShowIpv6RouteMatchTag( ShowCliCommandClass ):
   syntax = "show ipv6 route [ VRF ] ( PREFIX | ADDR ) match tag"
   data = {
           "ipv6": Ipv6.ipv6MatcherForShow,
           "route": IraIp6Cli.routeAfterShowIpv6Matcher,
           "VRF": IraIp6Cli.showRouteVrfNameExprFactory,
           "PREFIX": IraIp6Cli.ipv6PrefixMatcher,
           "ADDR": IraIp6Cli.ipv6AddrMatcher,
           "match": matchMatcher,
           "tag": tagMatcher,
          }

   handler = "RibIp6CliHandler.showRouteTag"

BasicCli.addShowCommandClass( ShowIpv6RouteMatchTag )

class ShowIpv6RouteAge( ShowCliCommandClass ):
   syntax = "show ipv6 route [ VRF ] ( PREFIX | ADDR ) age"
   data = {
           "ipv6": Ipv6.ipv6MatcherForShow,
           "route": IraIp6Cli.routeAfterShowIpv6Matcher,
           "VRF": IraIp6Cli.showRouteVrfNameExprFactory,
           "PREFIX": IraIp6Cli.ipv6PrefixMatcher,
           "ADDR": IraIp6Cli.ipv6AddrMatcher,
           "age": "Route age"
          }

   handler = "RibIp6CliHandler.showRouteAge"

BasicCli.addShowCommandClass( ShowIpv6RouteAge )

# -------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# -------------------------------------------------------------------------------
def Plugin( entityManager ):
   routing.plugin( entityManager )

   global l3Config

   l3Config = LazyMount.mount( entityManager, 'l3/config', 'L3::Config', 'r' )
