# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#------------------------------------------------------------------------------------
# This module provides Rib ipv4 cli functions that depend on cliribd.
#------------------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function
import BasicCli
import CliToken.Ip
import CliMatcher
import CliCommand
from CliPlugin import IpAddrMatcher
from CliPlugin import IraIpCli
from CliPlugin import IraRouteCommon
import LazyMount
from ShowCommand import ShowCliCommandClass

l3Config = None

ip = IraRouteCommon.Ip4()
routing = IraRouteCommon.routing( ip )

tagDeprecatedMatcher = CliCommand.Node(
                           CliMatcher.KeywordMatcher( 'tag', helpdesc='Route tag' ),
                           deprecatedByCmd='show ip route match tag' )

class ShowIpRouteTag( ShowCliCommandClass ):
   syntax = "show ip route [ VRF ] ( PREFIX | ADDR ) tag"
   data = {
           "ip": CliToken.Ip.ipMatcherForShow,
           "route": IraIpCli.routeMatcherAfterShowIp,
           "VRF": IraIpCli.vrfExprFactoryForShow,
           "ADDR": IpAddrMatcher.ipAddrMatcher,
           "PREFIX": IraIpCli.ipPrefixExpr,
           "tag": tagDeprecatedMatcher
          }

   handler = "RibIpCliHandler.showRouteTag"

BasicCli.addShowCommandClass( ShowIpRouteTag )

matchMatcher = CliMatcher.KeywordMatcher( 'match', helpdesc='Route tag' )
tagMatcher = CliMatcher.KeywordMatcher( 'tag', helpdesc='Route tag' )

class ShowIpRouteMatchTag( ShowCliCommandClass ):
   syntax = "show ip route [ VRF ] ( PREFIX | ADDR ) match tag"
   data = {
           "ip": CliToken.Ip.ipMatcherForShow,
           "route": IraIpCli.routeMatcherAfterShowIp,
           "VRF": IraIpCli.vrfExprFactoryForShow,
           "ADDR": IpAddrMatcher.ipAddrMatcher,
           "PREFIX": IraIpCli.ipPrefixExpr,
           "match": matchMatcher,
           "tag": tagMatcher
          }

   handler = "RibIpCliHandler.showRouteTag"

BasicCli.addShowCommandClass( ShowIpRouteMatchTag )

class ShowIpRouteAge( ShowCliCommandClass ):
   syntax = "show ip route [ VRF ] ( PREFIX | ADDR ) age"
   data = {
           "ip": CliToken.Ip.ipMatcherForShow,
           "route": IraIpCli.routeMatcherAfterShowIp,
           "VRF": IraIpCli.vrfExprFactoryForShow,
           "ADDR": IpAddrMatcher.ipAddrMatcher,
           "PREFIX": IraIpCli.ipPrefixExpr,
           "age": "Route age"
          }

   handler = "RibIpCliHandler.showRouteAge"

BasicCli.addShowCommandClass( ShowIpRouteAge )

# -------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# -------------------------------------------------------------------------------
def Plugin( entityManager ):
   routing.plugin( entityManager )

   global l3Config

   l3Config = LazyMount.mount( entityManager, 'l3/config', 'L3::Config', 'r' )
