# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliDynamicSymbol import LazyCallback
from CliPlugin.IraCommonCli import ribReadyHook

def Plugin( entityManager ):
   # This hook has been defined in Ira. Since both gated and IpRib use the same CLI
   # command, we need to call the correct method based on the protocol model in use
   # when this command is invoked. For this purpose, gated adds its callback method
   # as an extension to this 'ribReadyHook' and when the command is invoked, in IpRib
   # we look at the protocol model in use and invoke this hook if protocol model
   # 'ribd' is being used.
   ribReadyHook.addExtension(
      LazyCallback( "RibReadyCliHandler.showRibReadyState" ) )
