# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliModel import Model, Int, Dict, Str, Bool, Submodel
from ArnetModel import IpGenericPrefix, MacAddress, IpGenericAddress
from IntfModels import Interface

#------------------------------------------------------------------------------------
# CLI model for 'show route cache threshold'
#------------------------------------------------------------------------------------
class ThresholdParams( Model ):
   idleTime = Int(
          help="Idle time limit for prefixes at this threhold level in seconds" )
   hwUtil = Int(
          help="Hardware space utilization in percentage for this threhold level "
               "to kick in" )

class ThresholdLevels( Model ):
   thresholdParams = Dict( keyType=str, valueType=ThresholdParams,
         help="Threshold params for different levels" )

class RouteCacheSummary( Model ):
   configuredRoutes = Int( help="Number of routes configured" )
   routesInSfe = Int( help="Number of routes programmed in SFE" )
   routesInHw = Int( help="Number of routes programmed in Hardware" )
   unprogrammedRoutes = Int( help="Number of unprogrammed routes" )

class Summary( Model ):
   cmdErr = Str( optional=True, help="Error Message" )
   summary = Dict( optional=True, keyType=str, valueType=RouteCacheSummary,
         help="Route cache summary for IPv4" )
   summaryIPv6 = Dict( optional=True, keyType=str, valueType=RouteCacheSummary,
         help="Route cache summary for IPv6" )
   total = Submodel( valueType=RouteCacheSummary,
         help="Total across all VRFs and address families" )

class NextHopInfo( Model ):
   vxlanId = Interface( help="VXLAN Interface" )
   vni = Int( help="VNI" )
   macAddress = MacAddress( help="Overlay MAC address" )
   vlanId = Int( help="VLAN ID" )
   remoteVtep = IpGenericAddress( help="Remote VTEP IP address" )
   underlayFecId = Int( help="Underlay FEC ID" )

class PrefixData( Model ):
   inHw = Bool( optional=True, help="Prefix in hardware" )
   nextHopId = Int( optional=True, help="Next-hop index" )
   nextHopInfo = Dict( optional=True, keyType=int, valueType=NextHopInfo,
         help="Mapping of next-hop id to next-hop info" )

class Prefix( Model ):
   routes = Dict( optional=True, keyType=IpGenericPrefix,
         valueType=PrefixData, help="Mapping of prefix to its corresponding data" )

class VrfPrefix( Model ):
   cmdErr = Str( optional=True, help="Error message" )
   vrfs = Dict( optional=True, keyType=str,
         valueType=Prefix, help="Mapping of VRF name to IP routes" )
