# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import ConfigMount
import Tac
import Tracing

from CliPlugin.RouterGeneralCli import (
   RouterGeneralMode,
   routerGeneralCleanupHook,
   matcherRoute,
   matcherStatic
)

ecmpState = Tac.Type( 'Routing::General::StaticRouteEcmpState' )

traceHandle = Tracing.Handle( 'RouteEcmpStaticCli' )
t5 = traceHandle.trace5 # Info

config = None

def setStaticRouteEcmpState( state=ecmpState.strict, mode=None ):
   config.staticRouteEcmpState = state

class RouteEcmpStaticCmd( CliCommand.CliCommandClass ):
   syntax = 'route ecmp static relaxed'
   noOrDefaultSyntax = syntax
   data = {
      'route' : matcherRoute,
      'ecmp' : 'Equal-cost multi-path routing',
      'static' : matcherStatic,
      'relaxed' : 'Form ECMP with vias of different types',
   }

   @staticmethod
   def handler( mode, args ):
      setStaticRouteEcmpState( state=ecmpState.relaxed )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      setStaticRouteEcmpState()

RouterGeneralMode.addCommandClass( RouteEcmpStaticCmd )
routerGeneralCleanupHook.addExtension( setStaticRouteEcmpState )
t5( 'add command "[no] route ecmp static relaxed"' )


def Plugin( entityManager ):
   global config

   config = ConfigMount.mount( entityManager, 'routing/general/config/global',
                               'Routing::General::Config', 'w' )

