# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import ConfigMount
from CliPlugin.RouterGeneralCli import RouterGeneralMode
from CliPlugin.RouterGeneralCli import routerGeneralCleanupHook
from TypeFuture import TacLazyType
import CliToken.RouterGeneralCliTokens

RouteMapSourcePriority = TacLazyType( 'Routing::RouteMap::RouteMapSourcePriority' )

routeMapConfig = None

class RouterGeneralCommandReferenceUnconfCli( CliCommand.CliCommandClass ):
   """ @brief This class implements the CLI command:
           'command route-map policy reference unconfigured action error'
       @see aid/6468
   """
   syntax = 'command route-map policy reference unconfigured action error'
   noOrDefaultSyntax = syntax
   data = {
      'command' : CliToken.RouterGeneralCliTokens.cliKeywordCommand,
      'route-map' : CliToken.RouterGeneralCliTokens.cliKeywordRouteMap,
      'policy' : CliToken.RouterGeneralCliTokens.cliKeywordPolicy,
      'reference' : CliToken.RouterGeneralCliTokens.cliKeywordReference,
      'unconfigured' : CliToken.RouterGeneralCliTokens.cliKeywordUnconfigured,
      'action' : CliToken.RouterGeneralCliTokens.cliKeywordAction,
      'error' : CliToken.RouterGeneralCliTokens.cliKeywordError
   }

   @staticmethod
   def handler( mode, args ):
      routeMapConfig.routeMapPolicyReferenceUnconfiguredError = True

   @staticmethod
   def noOrDefaultHandler( mode, args=None ): # Hook passes in only `mode`.
      routeMapConfig.routeMapPolicyReferenceUnconfiguredError = False

RouterGeneralMode.addCommandClass( RouterGeneralCommandReferenceUnconfCli )
routerGeneralCleanupHook.addExtension(
      RouterGeneralCommandReferenceUnconfCli.noOrDefaultHandler )

#--------------------------------------------------------------------------------
# route-map source cli priority <value>
#--------------------------------------------------------------------------------
class PriorityCmd( CliCommand.CliCommandClass ):
   syntax = """route-map source cli priority [ PRIO ]"""
   noOrDefaultSyntax = syntax
   data = {
      'route-map': 'Route-map source configuration',
      'source': 'Source of route-map configuration', 
      'cli': CliMatcher.KeywordMatcher(
         'cli',
         helpdesc='CLI configuration' ),
      'priority': 'Priority of the CLI configured route maps',
      'PRIO': CliMatcher.IntegerMatcher( 0, 255,
         helpdesc='Priority value where 0 is the highest value' )
   }

   @staticmethod
   def handler( mode, args=None ): # Hook passes in only `mode` (no/def case).
      args = args or {}
      priority = args.get( 'PRIO', routeMapConfig.routeMapSourcePriorityDefault )
      routeMapConfig.routeMapSourcePriority = RouteMapSourcePriority( priority )

   noOrDefaultHandler = handler

RouterGeneralMode.addCommandClass( PriorityCmd )
routerGeneralCleanupHook.addExtension( PriorityCmd.noOrDefaultHandler )

def Plugin( entityManager ):
   global routeMapConfig
   routeMapConfig = ConfigMount.mount( entityManager,
                               'routing/routemap/config',
                               'Routing::RouteMap::Config', 'w' )
