# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliParser
from CliPlugin.VrfCli import  DEFAULT_VRF, RESERVED_VRF_NAMES
from CliMode.IgmpVrfMode import RoutingIgmpMode, RoutingIgmpVrfMode

class RouterIgmpMode( RoutingIgmpMode, BasicCli.ConfigModeBase  ):
   name = 'IGMP configuration'

   def __init__( self, parent, session ):
      self.vrfName = DEFAULT_VRF
      RoutingIgmpMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterIgmpVrfMode( RoutingIgmpVrfMode, BasicCli.ConfigModeBase  ):
   name = 'IGMP VRF configuration'

   def __init__( self, parent, session, vrfName ):
      assert vrfName not in RESERVED_VRF_NAMES
      self.vrfName = vrfName
      RoutingIgmpVrfMode.__init__( self, vrfName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterIgmpSharedModelet( CliParser.Modelet ):
   pass

RouterIgmpMode.addModelet( RouterIgmpSharedModelet )
RouterIgmpVrfMode.addModelet( RouterIgmpSharedModelet )

