# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from BasicCli import addShowCommandClass
from ShowCommand import ShowCliCommandClass
from CliPlugin.TunnelCli import (
      tokenTunnelMatcher,
      tunnelIndexMatcher,
   )
from CliToken.RoutingBgpShowCliTokens import (
      bgpAfterShow,
      forwarding,
      labeledUnicast,
      noLuForwardingFlattening,
      udpTunnelKeyword,
   )
import Toggles.TunnelToggleLib

# This file provides the CLI parser handling for BGP show commands that are
# about labeled-unicast SAFI

#-------------------------------------------------------------------------------
# "show bgp labeled-unicast tunnel [<tunnel-index>]"
#-------------------------------------------------------------------------------
class ShowBgpLuTunnel( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast tunnel [ TUNNELIDX_VAL ]"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "tunnel": tokenTunnelMatcher,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
      }
   cliModel = "BgpCliModels.BgpLuTunnelTable"
   handler = "RoutingBgpShowCliLuHandler.ShowBgpLuTunnel_handler"

addShowCommandClass( ShowBgpLuTunnel )

#-------------------------------------------------------------------------------
# HIDDEN
# "show bgp labeled-unicast tunnel [<tunnel-index>] raw"
#-------------------------------------------------------------------------------
class ShowBgpLuTunnelRaw( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast tunnel [ TUNNELIDX_VAL ] raw"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "tunnel": tokenTunnelMatcher,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
         "raw": noLuForwardingFlattening,
      }
   cliModel = "BgpCliModels.BgpLuTunnelTable"
   hidden = True
   handler = "RoutingBgpShowCliLuHandler.ShowBgpLuTunnelRaw_handler"

addShowCommandClass( ShowBgpLuTunnelRaw )

#-------------------------------------------------------------------------------
# "show bgp labeled-unicast forwarding [<tunnel-index>]"
#-------------------------------------------------------------------------------
class ShowBgpLuForwarding( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast forwarding [ TUNNELIDX_VAL ]"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "forwarding": forwarding,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
      }
   cliModel = "BgpCliModels.BgpLuForwardingTunnelTable"
   handler = "RoutingBgpShowCliLuHandler.ShowBgpLuForwarding_handler"

addShowCommandClass( ShowBgpLuForwarding )

#-------------------------------------------------------------------------------
# HIDDEN
# "show bgp labeled-unicast forwarding [<tunnel-index>] raw"
#-------------------------------------------------------------------------------
class ShowBgpLuForwardingRaw( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast forwarding [ TUNNELIDX_VAL ] raw"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "forwarding": forwarding,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
         "raw": noLuForwardingFlattening,
      }
   cliModel = "BgpCliModels.BgpLuForwardingTunnelTable"
   handler = "RoutingBgpShowCliLuHandler.ShowBgpLuForwardingRaw_handler"

addShowCommandClass( ShowBgpLuForwardingRaw )

#-------------------------------------------------------------------------------
# "show bgp tunnel udp"
#-------------------------------------------------------------------------------
class ShowBgpTunnelUdp( ShowCliCommandClass ):
   syntax = """show bgp tunnel udp"""
   data = {
         "bgp": bgpAfterShow,
         "tunnel": tokenTunnelMatcher,
         "udp": udpTunnelKeyword,
      }
   cliModel = "BgpCliModels.BgpUdpTunnelTable"
   handler = "RoutingBgpShowCliLuHandler.ShowBgpUdpTunnel_handler"

if Toggles.TunnelToggleLib.toggleDynamicGueTunnelsEnabled():
   addShowCommandClass( ShowBgpTunnelUdp )


