#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

# pylint: disable=anomalous-backslash-in-string
# pilint: disable=chained-comparison
# pilint: disable=consider-using-from-import
# pilint: disable=consider-using-f-string
# pylint: disable=inconsistent-return-statements
# pylint: disable=singleton-comparison
# pilint: disable=unnecessary-comprehension
# pylint: disable=unused-import
# pilint: disable=use-a-generator

import ipaddress
import Tac, LazyMount, SharedMem, Smash, SmashLazyMount
import ConfigMount
import CliParser, BasicCli, Arnet
from ReversibleSecretCli import ReversiblePasswordCliExpression
import DeviceNameLib
import CliPlugin.SegmentRoutingCli
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
from CliPlugin import IntfCli
from CliPlugin import Ip6AddrMatcher
from CliPlugin import IpAddrMatcher
from CliPlugin import IraVrfCli
from CliPlugin import IsisCliHelper
from CliPlugin import IsisCliModels
from CliPlugin import MplsModel
from CliPlugin import TechSupportCli
from CliPlugin.MplsCli import mplsNodeForShow, mplsForShowNode
from CliPlugin.RoutingCommon import GATED_PROTO_SH_TECH_TS
from CliPlugin.IsisCliModels import (
   TilfaTunnelTable
)

from CliPlugin.TunnelCli import (
   readMountTunnelTable,
   TunnelTableIdentifier,
   tokenTunnelMatcher,
   tunnelIndexMatcher
)

import CliToken
from CliToken.Router import routerMatcherForConfig as routerKw
import BasicCliUtil
from BasicCliUtil import notAPrefixOf
from CliParserCommon import namePattern

# pylint: disable=cyclic-import
import CliMatcher

import ShowCommand
import CliCommand
import SharkLazyMount
from TypeFuture import TacLazyType
from ConfigConsistencyChecker import UndefinedReferenceChecker
from Toggles import IpRibLibToggleLib
from Toggles import IsisToggleLib

# Exception not raised when try fails. Suppress pylint warning
# pylint: disable-msg=bare-except
# pylint: disable-msg=protected-access
# pylint: disable-msg=broad-except
l3Config = None
tilfaTunnelTable = None
isisSrV4BindingTable = None
isisSrV6BindingTable = None
isisConfig = None
isisStatusDir = None
isisClearReqDir = None
isisClearRespDir = None
srSysdbStatusDir = None
routingHardwareStatusCommon = None
routingHardwareStatus = None
routing6Config = None
routing6HardwareStatus = None
allIntfStatusDir = None
ipConfig  = None
ip6Config = None
vrfInfoDir = None
vrf6InfoDir = None
entityManager = None
linkReadyStatusVrfColl = None
ldpProtoConfigColl = None
ldpConfigColl = None
mplsRoutingConfig = None
mplsStatus = None
isisSystemIdHostnameMap = None
trapConfig = None
flexAlgoConfig = None
teConfig = None
sharedSecretConfig = None
filteredRibStatus = None

ArnetAddressFamily = TacLazyType( 'Arnet::AddressFamily' )
AuthAlgo = TacLazyType( 'Routing::Isis::AuthAlgo' )
AuthKeyid = TacLazyType( 'Routing::Isis::AuthKeyid' )
AuthMode = TacLazyType( 'Routing::Isis::AuthMode' )
HelloInterval = TacLazyType( 'Routing::Isis::HelloInterval' )
HelloMultiplier = TacLazyType( 'Routing::Isis::HelloMultiplier' )
InstanceStatus = TacLazyType( 'Routing::Isis::InstanceStatus' )
IpGenPrefix = TacLazyType( 'Arnet::IpGenPrefix' )
LspInterval = TacLazyType( 'Routing::Isis::LspInterval' )
Metric = TacLazyType( 'Routing::Isis::Metric' )
MplsLabel = TacLazyType( 'Arnet::MplsLabel' )
RouteTag = TacLazyType( 'Routing::Isis::RouteTag' )
Priority = TacLazyType( 'Routing::Isis::Priority' )
invalidInstanceName = Tac.Type( 'Routing::Isis::IntfConfig' ).instanceNameInvalid
srSidInvalid = Tac.Type( 'Routing::SegmentRoutingCli::Constants' ).srSidInvalid

SHA_KW_TO_TAC_TYPE_MAP = {
      'sha-1' : AuthAlgo.sha1,
      'sha-224' : AuthAlgo.sha224,
      'sha-256' : AuthAlgo.sha256,
      'sha-384' : AuthAlgo.sha384,
      'sha-512' : AuthAlgo.sha512,
}

SHARED_SECRET_ALGO_KW_TO_TAC_TYPE_MAP = {
      'md5' : AuthMode.md5,
      'sha-1' : AuthMode.sha_1,
      'sha-224' : AuthMode.sha_224,
      'sha-256' : AuthMode.sha_256,
      'sha-384' : AuthMode.sha_384,
      'sha-512' : AuthMode.sha_512
}

ipv4IPMatcher = IpAddrMatcher.ipAddrWithMaskExpr( 'IP address',
      'Subnet\'s mask value', 'IPv4 address prefix',
      overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO )
ipv6IPMatcher = Ip6AddrMatcher.Ip6PrefixMatcher( 'IPv6 address prefix',
      overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO )

#------------------------------------------------------------------------------
# Configuration keywords used by CLI parser
#------------------------------------------------------------------------------
adjacencySegmentKw = CliMatcher.KeywordMatcher( 'adjacency-segment',
      helpdesc='Set IS-IS SR adjacency segment interface configuration' )
afMatcher = CliMatcher.EnumMatcher( {
      'ipv4' : 'IPv4 related',
      'ipv6' : 'IPv6 related',
} )
globalKw = CliMatcher.KeywordMatcher( 'global',
      helpdesc='Global adjacency SID' )
indexKw = CliMatcher.KeywordMatcher( 'index',
      helpdesc='Index to be assigned as Adj-SID for adjacency on this interface' )
isisKw = CliMatcher.KeywordMatcher( 'isis',
      helpdesc='IS-IS commands' )
proxyNodeAttachedKw = CliMatcher.KeywordMatcher( 'attached',
      helpdesc='Directly connected prefix' )
labelKw = CliMatcher.KeywordMatcher( 'label',
      helpdesc='Label value to be assigned as Adj-SID for adjacency'
      ' on this interface' )
level12MatcherForConfig = CliMatcher.EnumMatcher( {
      'level-1' : 'Configure at level 1',
      'level-2' : 'Configure at level 2',
      'level-1-2' : 'Configure at level-1-2',
} )
levelMatcherForConfig = CliMatcher.EnumMatcher( {
      'level-1' : 'Configure at level 1',
      'level-2' : 'Configure at level 2',
} )
lspKw = CliMatcher.KeywordMatcher( 'lsp',
      helpdesc='Configure LSP specific parameters' )
multipleKw = CliMatcher.KeywordMatcher( 'multiple',
      helpdesc='configure multiple Adj-SIDs' )
p2pKw = CliMatcher.KeywordMatcher( 'p2p', helpdesc='P2P interface type' )
rfc8202Kw = CliMatcher.KeywordMatcher( 'rfc8202',
      helpdesc='IS-IS multi-instance RFC8202 support' )
unicastKw = CliMatcher.KeywordMatcher( 'unicast',
      helpdesc='Unicast sub-address family' )

#------------------------------------------------------------------------------
# Show keywords used by CLI parser
#------------------------------------------------------------------------------
dbKw = CliMatcher.KeywordMatcher( 'database',
      helpdesc='Database information' )
briefKw = CliMatcher.KeywordMatcher( 'brief',
      helpdesc='Display information in brief' )
detailKw = CliMatcher.KeywordMatcher( 'detail',
      helpdesc='Display information in detail' )
intervalKw = CliMatcher.KeywordMatcher( 'interval',
      helpdesc='Configure LSP transmission interval' )
isisLspDeprecatedKw = CliMatcher.KeywordMatcher( 'lsp-interval',
      helpdesc='Set LSP transmission interval' )
levelMatcherForShow = CliMatcher.EnumMatcher( {
      'level-1' : 'Level 1 only',
      'level-2' : 'Level 2 only',
} )
lspIdRegex = r"[A-Za-z0-9,_:\-\./#%+]{1,255}\.([0-9a-fA-F]{2}-[0-9a-fA-F]{2})"
lspIntervalMatcher = CliMatcher.IntegerMatcher( LspInterval.min,
      LspInterval.max,
      helpdesc='Interval value in milliseconds' )
lspKwForShow = CliMatcher.KeywordMatcher( 'lsp',
      helpdesc='IS-IS LSP information' )
singleLspidNode = CliCommand.singleNode( CliMatcher.PatternMatcher(
      pattern=lspIdRegex,
      helpdesc='LSPID in HHHH.HHHH.HHHH.HH-HH or hostname.HH-HH format',
      helpname='LSPID' ),
      sharedMatchObj=object() )
singleLevelNodeForShow = CliCommand.singleNode( levelMatcherForShow,
      sharedMatchObj=object() )
tokenTilfaForShow = CliMatcher.KeywordMatcher( 'ti-lfa',
      helpdesc='TI-LFA related path information' )
topologyKw = CliMatcher.KeywordMatcher( 'topology',
      helpdesc='Paths to IS-IS routers' )
txKw = CliMatcher.KeywordMatcher( 'tx',
      helpdesc='Configure LSP transmission parameter' )
vrfKw = CliMatcher.KeywordMatcher( 'vrf',
      helpdesc='VRF name' )

# Authentication related keywords
authPasswdMaxLen = 80
authPasswdMinLen = 1
authPasswdPattern = '.{%d,%d}' % ( authPasswdMinLen, authPasswdMaxLen )
authAlgoKw = CliMatcher.KeywordMatcher( 'algorithm',
      helpdesc="Configure authentication algorithm" )
authEncryptedPasswdKw = CliMatcher.PatternMatcher( '.+',
      helpname='WORD',
      helpdesc='Encrypted password' )
authKeyIdKw = CliMatcher.KeywordMatcher( 'key-id',
      helpdesc="Configure authentication keyid" )
authKeyKw = CliMatcher.KeywordMatcher( 'key',
      helpdesc="Configure authentication key" )
authKw = CliMatcher.KeywordMatcher( 'authentication',
      helpdesc='Configure authentication for IS-IS' )
authUnencryptedPasswdKw = CliMatcher.PatternMatcher( authPasswdPattern,
      helpname='WORD',
      helpdesc='Password (up to %d characters)' % authPasswdMaxLen )
clearIsisKw = CliMatcher.KeywordMatcher( 'isis',
      helpdesc='Clear IS-IS state' )
domainWidePurgeStr = "domain-wide-purge"
domainWidePurgeKw = CliMatcher.KeywordMatcher(
   domainWidePurgeStr, helpdesc="Flood purge LSP domain-wide",
   autoCompleteMinChars=len( domainWidePurgeStr ) )
encryptionType0Kw = CliMatcher.KeywordMatcher( '0',
      helpdesc='Encryption type - unencrypted' )
encryptionType7Kw = CliMatcher.KeywordMatcher( '7',
      helpdesc='Encryption type - proprietary' )
keyIdKw = CliMatcher.KeywordMatcher( 'key-id',
      helpdesc='Configure sender key-id' )
keyIdMatcher = CliMatcher.IntegerMatcher( AuthKeyid.shaMin,
      AuthKeyid.shaMax,
      helpdesc='Set key-id value' )
modeKw = CliMatcher.KeywordMatcher( 'mode',
      helpdesc='Configure authentication mode' )
rxDisabledKw = CliMatcher.KeywordMatcher( 'rx-disabled',
      helpdesc='Disable authentication on receive side' )
md5Kw = CliMatcher.KeywordMatcher( 'md5',
      helpdesc='HMAC-MD5 authentication' )
shaAlgoEnumMatcher = CliMatcher.EnumMatcher(
      { keyword : '%s authentication' %
         keyword.upper() for keyword in SHA_KW_TO_TAC_TYPE_MAP } )

sharedMatchObjDb = object()

#------------------------------------------------------------------------------
# Common patterns
#------------------------------------------------------------------------------


# Restricting the character list allowed in hostname as we would like to support
# filtering of LSP database based on LSPID with hostname in the system Id portion.
# This requires us to take LSPID as input which will be validated in cliribd as per
# CCTYPE_STRING. Without this we could end up in situations where we configure
# hostname, but fail to filter the LSP database stating invalid input.
# Hostnames will be restricted to alphanumeric and any of [,_:-./#%+]
hostnameRegex = r'[A-Za-z0-9,_:\-\./#%+]{1,255}'

#-------------------------------------------------------------------------------
# Guard function to prevent configuration on systems without routing support
#-------------------------------------------------------------------------------
def isisSupportedGuard( mode, token ):
   if routingHardwareStatus.routingSupported and routingHardwareStatus.isisSupported:
      return None
   return CliParser.guardNotThisPlatform

#-------------------------------------------------------------------------------
# Guard to prevent configuration in non-default VRF IS-IS instance
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# Guard to prevent configuration in non-default IS-IS instance (instance ID != 0)
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# Guard to prevent configuration in default IS-IS instance (instance ID 0)
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# Guard to prevent configuration in non-default VRF IS-IS instance and in
# non-default IS-IS instance (instance ID != 0)
#-------------------------------------------------------------------------------

indexValueMatcher = CliMatcher.IntegerMatcher( MplsLabel.min,
                              MplsLabel.max - MplsLabel.unassignedMin + 1,
                              helpdesc='Value of index' )
labelValueMatcher = CliMatcher.IntegerMatcher( MplsLabel.unassignedMin,
      MplsLabel.max,
      helpdesc='Value of the MPLS label' )

def isisIsEnabled():
   return len( isisConfig.instanceConfig ) > 0

#-------------------------------------------------------------------------------
# Isis commands in "show tech-support"
#-------------------------------------------------------------------------------
# In the future if we add commands that fork rib to produce their output, then
# we should split the list of commands into two. One list for commands that don't
# fork ribd using GATED_PROTO_SH_TECH_TS and the second one for commands that fork
# using GATED_PROTO_FORK_SH_TECH_TS
TechSupportCli.registerShowTechSupportCmd(
    GATED_PROTO_SH_TECH_TS,
    cmds=[ 'show isis summary vrf all',
           'show isis neighbors detail vrf all',
           'show isis interface detail vrf all',
           'show isis database traffic-engineering vrf all',
           'show isis hostname vrf all',
           'show isis network topology vrf all',
           'show isis spf log vrf all',
           'show isis graceful-restart vrf all',
           'show isis counters details vrf all',
           'show isis segment-routing adjacency-segments vrf all',
           'show isis segment-routing global-blocks vrf all',
           'show isis segment-routing prefix-segments vrf all',
           'show isis segment-routing tunnel',
           'show isis local-convergence-delay detail vrf all',
           'show isis lsp purges vrf all',
           'show isis ti-lfa tunnel' ],
    cmdsGuard=isisIsEnabled,
    summaryCmds=[ 'show isis summary vrf all',
                  'show isis neighbors vrf all',
                  'show isis interface vrf all',
                  'show isis segment-routing',
                  'show isis local-convergence-delay vrf all' ],
    summaryCmdsGuard=isisIsEnabled )

#-------------------------------------------------------------------------------
# router isis config mode. A new instance of this mode is created when the
# user enters "router isis".
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# ISIS area proxy config mode. A new instance of this mode is created when the
# user enters "area proxy".
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# ISIS-TE config mode. A new instance of this mode is created when the
# user enters "traffic-engineering".
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] router isis <instance-name> [vrf <vrf-name>]" command,
# in "config" mode.
# -------------------------------------------------------------------------------

def isisInstanceByVrfName( instanceConfig ):
   instDict = {}
   for i in instanceConfig.values():
      instDict.setdefault( i.vrfName, [] ).append( i.instanceName )
   return instDict

def deleteVrfHook( vrfName ):
   instanceByVrfName = isisInstanceByVrfName( isisConfig.instanceConfig )
   if vrfName in instanceByVrfName:
      return ( True, "IS-IS configuration for instance %s has been disabled" % \
                  instanceByVrfName[ vrfName ][ 0 ] )
   else:
      return ( True, None )


#--------------------------------------------------------------------------
# [no|default] router isis <INST> [ instance-id <INST_ID> |vrf <VRFNAME>]
#--------------------------------------------------------------------------
def getCurrentIsis( mode ):
   instNameCollection = {}
   for ( k, v ) in isisConfig.instanceConfig.items():
      instNameCollection[ k ] = ( 'Configure ISIS %s with instance ID %d in %s VRF'
            % ( k, v.instanceId, v.vrfName ) )
   return instNameCollection
isisKwMatcher = CliMatcher.KeywordMatcher( 'isis',
                     helpdesc="Intermediate System - Intermediate System (IS-IS)" )
instanceNamePattern = '.{1,100}'

instanceNameRule = CliCommand.Node( matcher=CliMatcher.PatternMatcher(
   instanceNamePattern, helpname='NAME',
   helpdesc='Name of the IS-IS protocol instance' ) )
instanceNameMatcher = CliMatcher.DynamicKeywordMatcher( getCurrentIsis )
instanceIdKw = CliMatcher.KeywordMatcher( 'instance-id',
                                          helpdesc='IS-IS instance identifier' )
instanceIdMin = 1
instanceIdMax = 65535
instanceIdMatcher = CliMatcher.IntegerMatcher( instanceIdMin, instanceIdMax,
                                               helpdesc='Instance ID' )
class RouterIsisModeCmd( CliCommand.CliCommandClass ):
   syntax = 'router isis ( NEW_INST | CURR_INST ) [ ( instance-id ID ) | VRF ]'
   noOrDefaultSyntax = 'router isis ( NEW_INST | CURR_INST ) ...'
   data = {
      'router' : routerKw,
      'isis'   : CliCommand.Node( matcher=isisKwMatcher,
                                  guard=isisSupportedGuard ),
      'NEW_INST'    : instanceNameRule,
      'CURR_INST'   : instanceNameMatcher,
      'instance-id' : instanceIdKw,
      'ID'          : instanceIdMatcher,
      'VRF' : VrfCli.VrfExprFactory( helpdesc="Configure IS-IS in a VRF instance" ),
   }
   handler = "RoutingIsisCliHandler.routerIsisModeCmd"
   noOrDefaultHandler = "RoutingIsisCliHandler.routerIsisModeCmdNo"

   @staticmethod
   def adapter( mode, args, argsList ):
      args[ 'INST' ] = args.get( 'CURR_INST', args.get( 'NEW_INST' ) )

BasicCli.GlobalConfigMode.addCommandClass( RouterIsisModeCmd )

# The "[no|default] route preference rfc7775" command
# under 'router isis <>' mode

#----------------------------------------------------------------------------------
# The "[no|default] lsp rfc8202 rx disabled" command
# under 'router isis <> instance-id <>' mode
#----------------------------------------------------------------------------------

#----------------------------------------------------------------------------------
# The "[no|default] rfc8202 disabled" command
# under 'router isis <> instance-id <>' mode
#----------------------------------------------------------------------------------

#----------------------------------------------------------------------------------
# The "[no|default] lsp purge origination-identification [ LEVEL ]" command
# under 'router isis <>' mode
#----------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# [no|default] is-type LEVEL under 'router isis <>' mode
#------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no | default] address-family AF [ unicast ]
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no | default] multi-topology"
# command, in config-router-isis-af mode.
#-------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# [no|default] traffic-engineering
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# [no|default] segment-routing mpls
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# Area proxy commands
# [no|default] area proxy
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# Area proxy commands
# [no|default] shutdown
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# Area proxy commands
# [no|default] net <NET>
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# Area proxy commands
# [no|default] is-hostname <HOSTNAME>
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# Area proxy commands
# [no|default] area segment (ipv4|ipv6) index <value>
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# Area proxy commands
# [no|default] router-id ipv4 [ROUTER_IDV4]
#---------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# [no|default] redistribute <static|connected|bgp> [include leaked]
#              [route-map <route-map-name>]
#------------------------------------------------------------------------------


#-----------------------------------------------------------------------------------
# [no|default] redistribute ospf [include leaked]
#              match <internal|external|nssa-exeternal> [route-map <route-map-name>]
#-----------------------------------------------------------------------------------


#-----------------------------------------------------------------------------------
# [no|default] redistribute bgp [include leaked] [route-map <route-map-name>]
#-----------------------------------------------------------------------------------


#-----------------------------------------------------------------------------------
# [no|default] route redistributed limit [level-1 | level-2] <Max Limit>
#-----------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] mpls ldp sync default" in 'router isis <>' mode
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# "[no|default] max-lsp-lifetime <time>" under 'router isis <>' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] lsp size maximum <size>" under 'router isis <>' mode
#-------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# '[no|default] is-hostname <hostname>' under 'router isis <>' mode
#---------------------------------------------------------------------------------

# TE CLI
#----------------------------------------------------
#"[no | default] shutdown" command, in isis - te mode
#----------------------------------------------------

#------------------------------------------------------------------------------
# [no|default] is-type LEVEL under isis-te mode
#------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] shutdown
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] log-adjacency-changes
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] log duplicate-system-id disabled
# command in "router isis" config mode
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] hello padding [disabled] command in "router isis <n>" config mode
#---------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] net <NET>" command in "router isis <n>" config mode.
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# "[no|default] area address <AREA>" command in "router isis <n>" config mode.
#-------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no] bfd all-interfaces in address-family v4 and v6 config mode
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# [no|default] spf-interval <max-wait> [ initial-wait [hold-time] ] command in
# "router isis <n>" config mode
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no] spf partial prefix command in "router isis <n>" config mode
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no] set-attached-bit route-map <rmName>  command in "router isis <n>" config mode
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# [no|default] "maximum-paths <paths>" command, in 'address-family mode'
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# "[no|default] lsp match flag attached action none | (install default-route)"
# command in 'address-family mode'.
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] lsp flooding dynamic [ LEVEL ]
# command in "router isis <n>" config mode
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# [no|default] passive <intfName>  command in "router isis <n>" config mode
#
# deprecated:
# [no|default] passive-interface <intfName>  command in "router isis <n>" config mode
#---------------------------------------------------------------------------------


#--------------------------------------------------------------------------------
# [no|default] timers lsp generation < max-wait > [ initial-wait ] [ hold-wait ]
# command in "router isis <n>" config mode
#--------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] timers lsp out-delay <LSP out-delay>
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] timers csnp generation interval <n> seconds
# in 'router isis' global mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] timers csnp generation p2p disabled
# in 'router isis' global mode
#-------------------------------------------------------------------------------

#------------------------------------------------------------------------------------
# timers local-convergence-delay [<delay_in_seconds>] protected-prefixes
# no|default timers local-convergence-delay protected-prefixes
# in 'router isis' global mode
#------------------------------------------------------------------------------------


#------------------------------------------------------------------------------------
# timers local-convergence-delay [<delay_in_seconds>] protected-prefixes
# no|default timers local-convergence-delay protected-prefixes
# in 'router-isis-af' mode
#------------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] timers lsp refresh <IS-IS LSP refresh-interval>"
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] timers lsp min-remaining-lifetime <n seconds>"
#-------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# area leader priority <priority> [ LEVEL ]
# area leader [ LEVEL ] [ disabled ]
# [no|default] area leader priority [ LEVEL ]
# [no|default] area leader [ LEVEL ] [ disabled ]
# command in "router isis" config mode
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] metric profile <profileName>
# command in "router isis" config mode
#---------------------------------------------------------------------------------


#---------------------------------------------------------------------------------
# [no|default] router-id ipv4 <ipv4Addr>
# [no|default] router-id ipv6 <ipv6Addr>  hidden for now since it has no effect
# commands in "router isis" config mode
#---------------------------------------------------------------------------------

metricValueMatcher = CliMatcher.IntegerMatcher(
      Metric.isisMetricMin + 1,
      Metric.isisMetricMax - 1,
      helpdesc='Value of the route metric' )
loopbackIntfMetricValueMatcher = CliMatcher.IntegerMatcher(
      Metric.isisMetricMin,
      Metric.isisMetricMax - 1,
      helpdesc='Value of the loopback route metric' )

#---------------------------------------------------------------------------------
# [no|default] metric <metricValue>
# command in "router isis metric profile" config mode
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] metric ratio <speed> <mbps|gbps>
# command in "router isis metric profile" config mode
#---------------------------------------------------------------------------------

#---------------------------------------------------------------------------------
# [no|default] metric <metricValue> if speed <= <speed> <mbps|gbps>
# command in "router isis metric profile" config mode
#---------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# Segment-Routing specific CLI
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] shutdown
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] segment path verification prefix-segment adjacency-segment
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] router-id <router-id>
#-------------------------------------------------------------------------------
# router-id configuration is not supposed to be under the RouterIsisSrMplsMode.
# Make it hidden for backward compatibility.


#-------------------------------------------------------------------------------
# [no|default] adjacency-segment allocation [none|sr-peers [backup-eligible]|
# all-interfaces [backup-eligible] ]
#-------------------------------------------------------------------------------
backupKw = CliMatcher.KeywordMatcher( 'backup-eligible',
                                      helpdesc='Eligible for protection' )


#-------------------------------------------------------------------------------
# [no|default] adjacency-segment sid reuse timeout <time>  XXX: Hidden
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] prefix-segment <prefix> index <index> [ explicit-null | no-php ]
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] flex-algo <name> [level-1|level-2|level-1-2] [advertised]
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# segment-routing ipv6 specific CLI
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] disabled' under 'segement-routing ipv6' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] locator LOCATOR' under 'segement-routing ipv6' mode
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# '[no|default] redistribute bgp' under 'address-family ipv[4|6]' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] redistribute user [route-map <route-map-name>] '
# 'under 'router isis' and 'address-family ipv[4|6]' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] redistribute dynamic [route-map <route-map-name>] '
# 'under 'router isis' and 'address-family ipv[4|6]' mode
#-------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------
# [no|default] tunnel source-protocol bgp ipv4 labeled-unicast [ rcf <func-name> ]
# under 'address-family ipv4' mode
#-----------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] redistribute dhcp' under 'address-family ipv6' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] redistribute isis level-1 into level-2 summary-address V4PREFIX'
# under 'address-family ipv4' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] redistribute isis level-1 into level-2 summary-address V6PREFIX'
# under 'address-family ipv6' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# '[no|default] redistribute isis level-1|level-2 into level-2|level-1 route-map <>'
# under 'address-family ipv[4|6]' mode
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# '[no|default] redistribute isis instance [route-map <>]'
# under 'router isis' and 'address-family ipv[4|6]' modes
#-------------------------------------------------------------------------------

#----------------------------------------------------------------------------------
# [no|default] "distance <1-255> [ LEVEL ]" command, in address-family mode
#----------------------------------------------------------------------------------


# [no] authentication mode ( md5 | sha key-id <id> | text | shared-secret profile
# <profileName> algorithm ( md5 | sha-1 | sha-224 | sha-256 | sha-384 | sha-512 ) )
# [ level-1 | level-2 | ( rx-disabled [ level-1 | level-2 ] ) ]
#---------------------------------------------------------------------------------

class AuthenticationModeExpression( CliCommand.CliExpression ):
   expression = '( md5 | text | ( sha key-id KEYID ) | ( shared-secret profile \
            PROFILE algorithm ( md5 | SHA ) ) )'

   data = {
      'md5' : md5Kw,
      'text' : 'Text authentication mode',
      'sha' : 'SHA authentication mode',
      'key-id' : keyIdKw,
      'KEYID' : keyIdMatcher,
      'shared-secret' : 'Specify a shared-secret',
      'profile' : 'Shared-secret profile',
      'PROFILE' : CliMatcher.DynamicNameMatcher( lambda mode:
                                                 sharedSecretConfig.profile,
                                                 'Shared-secret profile name' ),
      'algorithm' : authAlgoKw,
      'SHA' : shaAlgoEnumMatcher
   }


def getAuthModeData( args ):
   authMode = args.get( 'shared-secret' ) or args.get( 'sha' ) or args.get( 'md5' ) \
         or args.get( 'text' )
   authRxDisabled = args.get( 'rx-disabled' )
   authLevel = args.get( 'LEVEL' )
   keyid = AuthKeyid().idDefault
   sharedSecretProfileName = ''
   authModeVal = None
   if authMode == 'shared-secret':
      sharedSecretProfileName = args[ 'PROFILE' ]
      if args.get( 'md5' ):
         authModeVal = \
               SHARED_SECRET_ALGO_KW_TO_TAC_TYPE_MAP[ args[ 'md5' ] ]
      else:
         authModeVal = \
               SHARED_SECRET_ALGO_KW_TO_TAC_TYPE_MAP[ args[ 'SHA' ] ]
   elif authMode == 'sha':
      authModeVal = AuthMode.sha
      keyid = args[ 'KEYID' ]
   elif authMode == 'md5':
      authModeVal = AuthMode.md5
   elif authMode == 'text':
      authModeVal = AuthMode.clearText
   return ( authModeVal, keyid, authRxDisabled, authLevel,
            sharedSecretProfileName )

def generateIsisEncryptionKey( mode, args ):
   _, _, _, authLevel, _ = getAuthModeData( args )
   if isinstance( mode, IntfCli.IntfConfigMode ):
      intfConfig = _getOrCreateIntfConfig( isisConfig, mode.intf.name )
      instanceName = intfConfig.instanceName
      if not authLevel or authLevel == 'level-1':
         authModeVal = intfConfig.authModeL1
      else:
         authModeVal = intfConfig.authModeL2
   else:
      instanceName = mode.instanceName
      instanceConfig = isisConfig.instanceConfig[ mode.instanceName ]
      if not authLevel or authLevel == 'level-1':
         authModeVal = instanceConfig.authModeL1
      else:
         authModeVal = instanceConfig.authModeL2
   return instanceName + '_' + str( authModeVal )

#
#---------------------------------------------------------------------------------
# [no] authentication [key-id <id> algorithm SHA]
#       key [ [0|7|8a] < key-string > [ LEVEL ] ]
#---------------------------------------------------------------------------------
shaSyntax = ' algorithm SHA [ rfc-5310 ] '
keySyntax = ' PASS [LEVEL] '
authKeySyntax = 'authentication [ key-id ID' + shaSyntax + '] key' + keySyntax
noOrDefaultAuthSyntax = 'authentication ( key-id ID [' + shaSyntax + 'key'\
                        '[ ' + keySyntax + ' ] ] ) | ( key [' + keySyntax + '] )'
authKeyIntfSyntax = 'isis ' + authKeySyntax
noOrDefaultAuthIntfSyntax = 'isis ' + noOrDefaultAuthSyntax
authData = {
   'authentication' : authKw,
   'key-id': authKeyIdKw,
   'ID' : keyIdMatcher,
   'algorithm' : authAlgoKw,
   'SHA' : shaAlgoEnumMatcher,
   'rfc-5310' : 'SHA digest computation according to rfc5310',
   'key' : authKeyKw,
   'LEVEL' : CliMatcher.EnumMatcher( {
         'level-1' : 'Level-1 authentication',
         'level-2' : 'Level-2 authentication'
   } ),
   '0' : encryptionType0Kw,
   '7' : encryptionType7Kw,
   'PASS' : ReversiblePasswordCliExpression(
                     cleartextMatcher=authUnencryptedPasswdKw,
                     obfuscatedTextMatcher=authEncryptedPasswdKw,
                     type8aTextMatcher=authEncryptedPasswdKw,
                     uniqueKeyGenerator=generateIsisEncryptionKey,
                     algorithm='DES' ),
   'UPASS' : CliCommand.Node( matcher=authUnencryptedPasswdKw, sensitive=True ),
   'EPASS' : CliCommand.Node( matcher=authEncryptedPasswdKw, sensitive=True ),
}
authKeyIntfSyntax = 'isis ' + authKeySyntax
noOrDefaultAuthIntfSyntax = 'isis ' + noOrDefaultAuthSyntax
authIntfData = dict( authData )
authIntfData[ 'isis' ] = isisKw


#-----------------------------------------------------------------------------
# [no| default ] maximum-sid-depth base-mpls-imposition
#-----------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# Adds isis-specific CLI commands to the "config-if" mode for routed ports.
# Enable isis commands under config-if only on routed and loopback ports
#-------------------------------------------------------------------------------
def isisSupportedOnIntfConfigMode( intfConfigMode ):
   # Don't configure isis on ineligible interfaces
   if intfConfigMode.intf.routingSupported() and \
          not intfConfigMode.intf.name.startswith( "Management" ):
      return True
   return False

def isIntfLoopback( intfConfigMode ):
   return intfConfigMode.intf.name.startswith( 'Loopback' )

class RoutingProtocolIsisIntfConfigModelet( CliParser.Modelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      return isisSupportedOnIntfConfigMode( mode )

class RoutingProtocolIsisNonLoopbackIntfConfigModelet(
      RoutingProtocolIsisIntfConfigModelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      return isisSupportedOnIntfConfigMode( mode ) and not isIntfLoopback( mode )

class RoutingProtocolIsisLoopbackIntfConfigModelet(
      RoutingProtocolIsisIntfConfigModelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      return isIntfLoopback( mode )

class RoutingProtocolIsisIntfMetricConfigModelet(
      RoutingProtocolIsisIntfConfigModelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      return  isisSupportedOnIntfConfigMode( mode ) and \
              not isIntfLoopback( mode )

class RoutingProtocolIsisLoopbackIntfMetricConfigModelet(
      RoutingProtocolIsisIntfConfigModelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      return isIntfLoopback( mode )

#-------------------------------------------------------------------------------
# Associate the interface config modelets with the "config-if" mode.
#-------------------------------------------------------------------------------
IntfCli.IntfConfigMode.addModelet( RoutingProtocolIsisIntfConfigModelet )
IntfCli.IntfConfigMode.addModelet( RoutingProtocolIsisNonLoopbackIntfConfigModelet )
IntfCli.IntfConfigMode.addModelet( RoutingProtocolIsisLoopbackIntfConfigModelet )
IntfCli.IntfConfigMode.addModelet( RoutingProtocolIsisIntfMetricConfigModelet )
IntfCli.IntfConfigMode.addModelet(
      RoutingProtocolIsisLoopbackIntfMetricConfigModelet )

def isisConfiguration():
   return isisConfig

class IsisIntf( IntfCli.IntfDependentBase ):

   def setDefault( self ):
      config = isisConfiguration()
      del config.intfConfig[ self.intf_.name ]

modelet = RoutingProtocolIsisIntfConfigModelet

#-------------------------------------------------------------------------------
# SrConfig stores all common sr configuration for OSPF and ISIS (only node segment
# for now)
#-------------------------------------------------------------------------------
srConfig = None
def _getSrIntfConfig( intfName ):
   return srConfig.intfConfig.get( intfName, None )

#-------------------------------------------------------------------------------
# IntfConfig for ISIS configuration, is created when one of its attributes
# is configured. It is deleted when all the attributes are at their defaults
# What this means is that after the last "no isis..." command is run on the
# interface, we delete the intfConfig object
#-------------------------------------------------------------------------------
def _getIntfConfig( intfName ):
   return isisConfiguration().intfConfig.get( intfName, None )

def _getOrCreateIntfConfig( config, intfName ):
   intfConfig = config.intfConfig.get( intfName, None )
   if intfConfig is None:
      intfConfig = config.intfConfig.newMember( intfName )
   return intfConfig

#-------------------------------------------------------------------------------
# "[no|default] isis enable"
# command, in config-if mode.
# "[no|default] isis instance <INSTANCE_NAME>"
# command, in loopback config-if mode.
#-------------------------------------------------------------------------------
instanceNameKw = CliMatcher.DynamicNameMatcher(
   lambda mode: isisConfig.instanceConfig,
   'Name of the IS-IS protocol instance',
   pattern=instanceNamePattern )

ribFilterNameKw = CliMatcher.DynamicNameMatcher(
   lambda mode: filteredRibStatus.result,
   'Name of the unicast RIB',
   pattern=namePattern )

class IsisLoopbackIntfInstanceCmd( CliCommand.CliCommandClass ):
   syntax = 'isis instance INSTANCE_NAME'
   noOrDefaultSyntax = 'isis instance INSTANCE_NAME...'

   data = {
      'isis' : isisKw,
      'instance' : 'Enable IS-IS protocol on the interface',
      'INSTANCE_NAME' : instanceNameKw
   }
   handler = "RoutingIsisCliHandler.setIsisEnable"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisEnable"

class IsisIntfEnableCmd( CliCommand.CliCommandClass ):
   syntax = 'isis enable INSTANCE_NAME'
   noOrDefaultSyntax = 'isis enable ...'
   data = {
      'isis' : isisKw,
      'enable' : 'Enable IS-IS protocol on the interface',
      'INSTANCE_NAME' : instanceNameKw
   }
   handler = "RoutingIsisCliHandler.setIsisEnable"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisEnable"

class IsisLoopbackIntfEnableCmd( CliCommand.CliCommandClass ):
   syntax = 'isis enable INSTANCE_NAME [ condition unicast-rib { RIB_NAME } ]'
   noOrDefaultSyntax = 'isis enable ...'
   data = {
      'isis': isisKw,
      'enable': 'Enable IS-IS protocol on the interface',
      'INSTANCE_NAME': instanceNameKw,
      'condition': 'Enable IS-IS protocol when conditions are met',
      'unicast-rib': 'Enable IS-IS protocol when all the unicast RIBs are not empty',
      'RIB_NAME': ribFilterNameKw
   }
   handler = "RoutingIsisCliHandler.setIsisEnable"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisEnable"

if IpRibLibToggleLib.toggleIsisConditionalAdvertiseEnabled():
   RoutingProtocolIsisNonLoopbackIntfConfigModelet.addCommandClass(
      IsisIntfEnableCmd )
   RoutingProtocolIsisLoopbackIntfConfigModelet.addCommandClass(
      IsisLoopbackIntfEnableCmd )
else:
   modelet.addCommandClass( IsisIntfEnableCmd )
RoutingProtocolIsisLoopbackIntfConfigModelet.addCommandClass(
   IsisLoopbackIntfInstanceCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis rfc8202 disabled
# command, in config-if mode.
#-------------------------------------------------------------------------------

class IsisIntfRfc8202DisabledCmd( CliCommand.CliCommandClass ):
   syntax = 'isis rfc8202 disabled'
   noOrDefaultSyntax = syntax
   data = {
      'isis' : isisKw,
      'rfc8202' : rfc8202Kw,
      'disabled' : 'Disable RFC8202 compliance to enable peering with'
                   ' non-multi-instance capable routers'
   }
   handler = "RoutingIsisCliHandler.setIsisRfc8202Disabled"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisRfc8202Disabled"
modelet.addCommandClass( IsisIntfRfc8202DisabledCmd )
#-------------------------------------------------------------------------------
# "[no|default] isis metric <value> | <maximum>"
# command, in config-if mode.
#-------------------------------------------------------------------------------
isisIntfMetricMatcher = CliMatcher.KeywordMatcher( 'metric',
      helpdesc='Set the metric for interface' )
isisIntfMetricMaxMatcher = CliMatcher.KeywordMatcher( 'maximum',
      helpdesc='Maximum metric value' )
class IsisIntfMetricCmd( CliCommand.CliCommandClass ):
   syntax = 'isis metric ( METRIC_VALUE | maximum )'
   noOrDefaultSyntax = 'isis metric ...'
   data = {
      'isis' : isisKw,
      'metric' : isisIntfMetricMatcher,
      'METRIC_VALUE' : metricValueMatcher,
      'maximum' : isisIntfMetricMaxMatcher
   }
   handler = "RoutingIsisCliHandler.setIsisIntfMetric"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfMetric"

class IsisLoopbackIntfMetricCmd( CliCommand.CliCommandClass ):
   syntax = 'isis metric ( METRIC_VALUE | maximum )'
   noOrDefaultSyntax = 'isis metric ...'
   data = {
      'isis' : isisKw,
      'metric' : isisIntfMetricMatcher,
      'METRIC_VALUE' : loopbackIntfMetricValueMatcher,
      'maximum' : isisIntfMetricMaxMatcher
   }
   handler = "RoutingIsisCliHandler.setIsisIntfMetric"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfMetric"

RoutingProtocolIsisIntfMetricConfigModelet.addCommandClass( IsisIntfMetricCmd )
RoutingProtocolIsisLoopbackIntfMetricConfigModelet.addCommandClass(
            IsisLoopbackIntfMetricCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis ipv6 metric <value> | <maximum>"
# command, in config-if mode.
#-------------------------------------------------------------------------------
isisIntfIpv6Matcher = CliMatcher.KeywordMatcher( 'ipv6',
      helpdesc='IS-IS IPv6 interface config' )
class IsisIntfIPV6MetricCmd( CliCommand.CliCommandClass ):
   syntax = 'isis ipv6 metric ( METRIC_VALUE | maximum )'
   noOrDefaultSyntax = 'isis ipv6 metric ...'
   data = {
      'isis' : isisKw,
      'ipv6' : isisIntfIpv6Matcher,
      'metric' : isisIntfMetricMatcher,
      'METRIC_VALUE' : metricValueMatcher,
      'maximum' : isisIntfMetricMaxMatcher
   }
   handler = "RoutingIsisCliHandler.setIsisIntfV6Metric"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfV6Metric"

class IsisLoopbackIntfIPV6MetricCmd( CliCommand.CliCommandClass ):
   syntax = 'isis ipv6 metric ( METRIC_VALUE | maximum )'
   noOrDefaultSyntax = 'isis ipv6 metric ...'
   data = {
      'isis' : isisKw,
      'ipv6' : isisIntfIpv6Matcher,
      'metric' : isisIntfMetricMatcher,
      'METRIC_VALUE' : loopbackIntfMetricValueMatcher,
      'maximum' : isisIntfMetricMaxMatcher
   }
   handler = "RoutingIsisCliHandler.setIsisIntfV6Metric"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfV6Metric"

RoutingProtocolIsisIntfMetricConfigModelet.addCommandClass( IsisIntfIPV6MetricCmd )
RoutingProtocolIsisLoopbackIntfMetricConfigModelet.addCommandClass(
            IsisLoopbackIntfIPV6MetricCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis metric profile <profileName>"
# command, in config-if mode.
#-------------------------------------------------------------------------------
def getAllMetricProfiles( mode ):
   return sum( ( list( cfg.metricProfiles ) for cfg in
                              isisConfig.instanceConfig.values() ), [] )

isisIntfProfileMatcher = CliMatcher.KeywordMatcher( 'profile',
      helpdesc='Set the metric profile for interface' )
isisIntfProfileNameMatcher = CliMatcher.DynamicNameMatcher( getAllMetricProfiles,
      'IS-IS metric profile name', pattern=instanceNamePattern )

class IsisIntfMetricProfileCmd( CliCommand.CliCommandClass ):
   syntax = 'isis metric profile PROFILE_NAME'
   noOrDefaultSyntax = 'isis metric profile ...'
   data = {
      'isis' : isisKw,
      'metric' : isisIntfMetricMatcher,
      'profile' : isisIntfProfileMatcher,
      'PROFILE_NAME' : isisIntfProfileNameMatcher
   }
   handler = "RoutingIsisCliHandler.setMetricProfile"
   noOrDefaultHandler = handler

modelet.addCommandClass( IsisIntfMetricProfileCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis ipv6 metric profile <profileName>"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfIPV6MetricProfileCmd( CliCommand.CliCommandClass ):
   syntax = 'isis ipv6 metric profile PROFILE_NAME'
   noOrDefaultSyntax = 'isis ipv6 metric profile ...'
   data = {
      'isis' : isisKw,
      'ipv6' : isisIntfIpv6Matcher,
      'metric' : isisIntfMetricMatcher,
      'profile' : isisIntfProfileMatcher,
      'PROFILE_NAME' : isisIntfProfileNameMatcher
   }
   handler = "RoutingIsisCliHandler.setMetricProfileV6"
   noOrDefaultHandler = handler

modelet.addCommandClass( IsisIntfIPV6MetricProfileCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis multi-topology address-family ( ipv4 | ipv6 ) [ unicast ]"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfMultiTopologyCmd( CliCommand.CliCommandClass ):
   syntax = 'isis multi-topology address-family AF [ unicast ]'
   noOrDefaultSyntax = syntax
   data = {
      'isis' : isisKw,
      'multi-topology' : 'Set multi topology IS-IS interface config',
      'address-family' : 'Enable interface address family',
      'AF' : afMatcher,
      'unicast' : unicastKw
   }
   handler = "RoutingIsisCliHandler.setIsisIntfMtAf"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfMtAf"

modelet.addCommandClass( IsisIntfMultiTopologyCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis circuit-type LEVEL"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfCircuitTypeCmd( CliCommand.CliCommandClass ):
   syntax = 'isis circuit-type LEVEL'
   noOrDefaultSyntax = 'isis circuit-type ...'
   data = {
      'isis' : isisKw,
      'circuit-type' : 'Set level of the interface',
      'LEVEL' : level12MatcherForConfig,
   }
   handler = "RoutingIsisCliHandler.setIsisIntfCircuitType"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfCircuitType"

modelet.addCommandClass( IsisIntfCircuitTypeCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis area proxy boundary"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfAreaProxyBoundaryCmd( CliCommand.CliCommandClass ):
   syntax = 'isis area proxy boundary'
   noOrDefaultSyntax = syntax
   data = {
      'isis' : isisKw,
      'area' : 'Set area parameters',
      'proxy' : 'Set area proxy parameters',
      'boundary' : 'Set area proxy boundary'
   }
   handler = "RoutingIsisCliHandler.setIntfAreaProxyBoundary"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIntfAreaProxyBoundary"

modelet.addCommandClass( IsisIntfAreaProxyBoundaryCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis priority"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfPriorityCmd( CliCommand.CliCommandClass ):
   syntax = 'isis priority PRIORITY_VALUE'
   noOrDefaultSyntax = 'isis priority ...'
   data = {
      'isis' : isisKw,
      'priority' : 'DR election priority',
      'PRIORITY_VALUE' : CliMatcher.IntegerMatcher(
            Priority.isisPriorityMin,
            Priority.isisPriorityMax,
            helpdesc='Priority value' ),
   }
   handler = "RoutingIsisCliHandler.setIsisIntfPriority"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfPriority"

modelet.addCommandClass( IsisIntfPriorityCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis hello-interval <interval>"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfHelloIntervalCmd( CliCommand.CliCommandClass ):
   syntax = 'isis hello-interval INTERVAL'
   noOrDefaultSyntax = 'isis hello-interval ...'
   data = {
      'isis' : isisKw,
      'hello-interval' : 'Set hello interval',
      'INTERVAL' : CliMatcher.IntegerMatcher(
            HelloInterval.min,
            HelloInterval.max,
            helpdesc='Hello interval value in seconds' ),
   }
   handler = "RoutingIsisCliHandler.setIsisHelloInterval"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisHelloInterval"

modelet.addCommandClass( IsisIntfHelloIntervalCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis hello-multiplier <multiplier>"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfHelloMultiplierCmd( CliCommand.CliCommandClass ):
   syntax = 'isis hello-multiplier MULTIPLIER'
   noOrDefaultSyntax = 'isis hello-multiplier ...'
   data = {
      'isis' : isisKw,
      'hello-multiplier' : 'Set hello multiplier for hold time',
      'MULTIPLIER' : CliMatcher.IntegerMatcher(
            HelloMultiplier.min,
            HelloMultiplier.max,
            # FIXME: Is this help correct? Aren't multipliers unitless?
            helpdesc='Hello multiplier value in seconds' ),
   }
   handler = "RoutingIsisCliHandler.setIsisHelloMultiplier"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisHelloMultiplier"

modelet.addCommandClass( IsisIntfHelloMultiplierCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis lsp tx interval <interval>"
# command, in config-if mode.
#
# legacy:
# "[no|default] isis lsp-interval <interval>"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class RouterIsisIntfLspTxIntervalCmd( CliCommand.CliCommandClass ):
   syntax = 'isis ( ( lsp tx interval ) | lsp-interval ) INTERVAL'
   noOrDefaultSyntax = 'isis ( ( lsp tx interval ) | ( lsp-interval ) ) ...'
   data = {
      'isis' : isisKw,
      'lsp-interval' : CliCommand.Node( matcher=isisLspDeprecatedKw,
                                        deprecatedByCmd='isis lsp tx interval' ),
      'lsp' : lspKw,
      'tx' : txKw,
      'interval' : intervalKw,
      'INTERVAL' : lspIntervalMatcher
   }

   handler = "RoutingIsisCliHandler.RouterIsisIntfLspTxIntervalCmd_handler"
   noOrDefaultHandler = \
            "RoutingIsisCliHandler.RouterIsisIntfLspTxIntervalCmd_noOrDefaultHandler"

modelet.addCommandClass( RouterIsisIntfLspTxIntervalCmd )

#-------------------------------------------------------------------------------
#"[no|default] isis passive
# command in config-if mode
#-------------------------------------------------------------------------------
class IsisIntfPassiveCmd( CliCommand.CliCommandClass ):
   syntax = 'isis passive'
   noOrDefaultSyntax = syntax
   data = {
      'isis' : isisKw,
      'passive' : 'Include interface but without actively running IS-IS'
   }
   handler = "RoutingIsisCliHandler.setIntfPassive"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIntfPassive"

modelet.addCommandClass( IsisIntfPassiveCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis network point-to-point"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfNetworkCmd( CliCommand.CliCommandClass ):
   syntax = 'isis network point-to-point'
   noOrDefaultSyntax = 'isis network ...'
   data = {
      'isis' : isisKw,
      'network' : 'Set the network type',
      'point-to-point' : 'Network type point to point'
   }
   handler = "RoutingIsisCliHandler.setIsisIntfType"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfType"

modelet.addCommandClass( IsisIntfNetworkCmd )

#---------------------------------------------------------------------------------
# [no] isis authentication mode [ < text|md5|sha key-id <keyid> > [rx-disabled]
# [ LEVEL ] ]
# in intf config mode
#---------------------------------------------------------------------------------
class IsisIntfModeAuthenticationMode( CliCommand.CliCommandClass ):
   syntax = 'isis authentication mode AUTHMODE [ rx-disabled ] [ LEVEL ]'
   noOrDefaultSyntax = '''isis authentication mode
                          [ AUTHMODE [ rx-disabled ] [ LEVEL ] ]'''
   data = {
      'isis' : isisKw,
      'authentication' : authKw,
      'mode' : modeKw,
      'AUTHMODE' : AuthenticationModeExpression,
      'rx-disabled' : rxDisabledKw,
      'LEVEL' : levelMatcherForConfig,
   }

   handler = "RoutingIsisCliHandler.IsisIntfModeAuthenticationMode_handler"
   noOrDefaultHandler = \
            "RoutingIsisCliHandler.IsisIntfModeAuthenticationMode_noOrDefaultHandler"

modelet.addCommandClass( IsisIntfModeAuthenticationMode )

#
#---------------------------------------------------------------------------------
# [no] isis authentication [key-id <id> algorithm SHA ]
#       key [ [0|7] < key-string > [ LEVEL ] ]
#---------------------------------------------------------------------------------
class RouterIsisIntfAuthenticationKeyCmd( CliCommand.CliCommandClass ):
   syntax = authKeyIntfSyntax
   noOrDefaultSyntax = noOrDefaultAuthIntfSyntax
   data = authIntfData

   handler = "RoutingIsisCliHandler.RouterIsisIntfAuthenticationKeyCmd_handler"
   noOrDefaultHandler = \
      "RoutingIsisCliHandler.RouterIsisIntfAuthenticationKeyCmd_noOrDefaultHandler"

modelet.addCommandClass( RouterIsisIntfAuthenticationKeyCmd )

# Helper function to check for a conflicting prefix/proxy/node segment
def _isisSrConflictingPrefixFound( instanceName, intfName, prefix,
                                   proxy=False, mode=None, rangeVal=1,
                                   ignoreConflict=False, algoName='' ):
   if mode and mode.session_.skipConfigCheck():
      return False
   if proxy:
      segType = 'proxy'
   elif intfName:
      segType = 'node'
   else:
      segType = 'prefix'

   # Get the first and the last address in the range
   pfxStr, _ = str( prefix ).split( '/' )
   startPfx = ipaddress.ip_address( pfxStr )
   endPfx = startPfx + rangeVal - 1
   
   # If we find a prefix segment with the same key as 'prefix'
   # it's a conflict
   instanceConfig = isisConfig.instanceConfig.get( instanceName )
   if instanceConfig:
      algoPrefix = Tac.Value( "Routing::Isis::AlgoNamePrefix", algoName=algoName,
                              prefix=prefix )
      value = instanceConfig.srPrefixSegments.get( algoPrefix )
      if value is not None:
         if value.isProxyNode:
            nodeType = 'proxy'
         else:
            nodeType = 'prefix'
         if nodeType != segType:
            return True

      # Check if there are any overlapping prefixes with the range config
      for key, value in instanceConfig.srPrefixSegments.items():
         if ( not key.prefix.isHost or key.prefix.af != prefix.af or
              key.prefix == prefix ):
            continue
         startAddr, _ = str( key.prefix ).split( '/' )
         startVal = ipaddress.ip_address( startAddr )
         endVal = startVal + value.range - 1

         # RFE954448: case "conflict ignore"
         # Ignore overlapping prefix conflict check between proxy-node range with
         # prefix and node segments but the starting address must not match
         # which is already covered above
         # check 1: incoming prefix or node with existing proxy-node range
         # check 2: incoming proxy-node range with existing prefix
         if ( segType != 'proxy' and
              value.isProxyNode and value.ignoreConflict ) or \
            ( not value.isProxyNode and
              segType == 'proxy' and ignoreConflict ):
            continue

         if startVal <= endPfx and endVal >= startPfx:
            return True

   # RFE954448: case "conflict ignore"
   #     Ignore conflict between node sid ip and proxy-node range overlapping prefix
   #     but starting proxy-node range ip must not conflict with node-sid ip
   #
   # To acheive this, we are calculating endPfx based on rangeVal as 1
   # which will ensure that we check the starting prefix of proxy-node range with
   # node sid ip address but ignore the conflict if node sid comes in the range of
   # proxy-node prefixes.
   if segType == 'proxy' and ignoreConflict:
      endPfx = startPfx

   # If we find a node segment on an interface and the IP address
   # on that interface is same as 'prefix' it's a conflict
   for interface, intfConfig in isisConfig.intfConfig.items():
      if intfName and intfName == interface:
         continue
      # Check against intfConfig.instName and intfConfig.multiInstanceName as
      # the former holds the instances configured with isis enable <>
      # and later holds the instances configured with isis instance <> command
      if ( ( intfConfig.instanceName == intfConfig.instanceNameInvalid or
           intfConfig.instanceName != instanceName ) and
           instanceName not in intfConfig.multiInstanceName ):
         continue
      # Check if the interface has a corresponding node-segment configuration,
      # if yes check if the prefixes are same (this is to identify the case
      # where we are trying to configure a prefix-segment, but there is already
      # a node-segment corresponding to the same prefix)
      srIntfConfig = _getSrIntfConfig( interface )
      if srIntfConfig is None:
         continue
      
      if ( prefix.af == ArnetAddressFamily.ipv4 and
           ( srIntfConfig.srNodeSegmentIndex != srSidInvalid or
             srIntfConfig.srV4NodeSegment or
             srIntfConfig.srV4NodeSegmentLabel ) ):
         ipIntfConfig = ipConfig.ipIntfConfig.get( interface )
         if not ipIntfConfig:
            continue
         
         ipPfx, ipMask = ipIntfConfig.addrWithMask.subnet.stringValue.split( '/' )
         if not prefix.isHost or ipMask != '32':
            if ipIntfConfig.addrWithMask.subnet.stringValue == prefix.stringValue:
               return True
         else:
            intfPfx = ipaddress.ip_address( ipPfx )
            if startPfx <= intfPfx <= endPfx:
               return True
      elif ( prefix.af == ArnetAddressFamily.ipv6 and
             ( srIntfConfig.srV6NodeSegmentIndex != srSidInvalid or
               srIntfConfig.srV6NodeSegment or
               srIntfConfig.srV6NodeSegmentLabel ) ):
         ip6IntfConfig = ip6Config.intf.get( interface )
         if not ip6IntfConfig:
            continue
      
         for ip6IntfPfx in ip6IntfConfig.addr:
            ip6Pfx, ip6Mask = ip6IntfPfx.stringValue.split( '/' )
      
            if not prefix.isHost or ip6Mask != '128':
               if Arnet.Ip6AddrWithMask( prefix ) == ip6IntfPfx:
                  return True
            else:
               intf6Pfx = ipaddress.ip_address( ip6Pfx )
               if startPfx <= intf6Pfx <= endPfx:
                  return True
   return False

# Helper function to check for a conflicting SR SID
def _isisSrConflictingSidFound( instanceName, intfName, prefix, sid, mode=None,
                                rangeVal=1, algoName='' ):

   if mode and mode.session_.skipConfigCheck():
      return False
   
   startIdx = sid
   endIdx = sid + rangeVal - 1
   # If we find a prefix segment with key other than 'prefix'
   # using this SID, it's a conflict
   instanceConfig = isisConfig.instanceConfig.get( instanceName )
   if instanceConfig:
      for key, value in instanceConfig.srPrefixSegments.items():
         # If the value to check is an index, only compare it to
         # other prefixes which have an index config
         if value.label == value.labelInvalid:
            if key.prefix != prefix or key.algoName != algoName:
               startVal = value.index
               endVal = value.index + value.range - 1
               # check if the two ranges overlap
               if startVal <= endIdx and endVal >= startIdx:
                  return True
   
   # If we find a node segment on an interface using this
   # index with any ISIS instance, it's a conflict regardless
   # of the IP address on that interface
   if instanceName == '':
      return False
   for interface, intfConfig in isisConfig.intfConfig.items():
      if intfName and intfName == interface:
         continue
      if intfConfig.instanceName == intfConfig.instanceNameInvalid or \
             intfConfig.instanceName != instanceName:
         continue
      # If the interface has node-segment configuration check for sid conflicts
      srIntfConfig = _getSrIntfConfig( interface )
      if srIntfConfig:
         # Check for all sids in the range
         if ( startIdx <= srIntfConfig.srNodeSegmentIndex <= endIdx or
              startIdx <= srIntfConfig.srV6NodeSegmentIndex <= endIdx ):
            return True
         if any( startIdx <= s <= endIdx for s in srIntfConfig.srV4NodeSegment ):
            return True
         if any( startIdx <= s <= endIdx for s in srIntfConfig.srV6NodeSegment ):
            return True
   return False

def checkLabelConflictWithinInterface( srIntfConfig, startLabel, endLabel, ipv6 ):
   if ( ipv6 and any( startLabel <= l <= endLabel
                      for l in srIntfConfig.srV4NodeSegmentLabel ) ):
      return True
   if ( not ipv6 and any( startLabel <= l <= endLabel
                          for l in srIntfConfig.srV6NodeSegmentLabel ) ):
      return True
   return False

# Helper function to check for a conflicting SR Label
def _isisSrConflictingLabelFound( instanceName, intfName, prefix, label, ipv6=False,
                                  mode=None, rangeVal=1, algoName='' ):
   if mode and mode.session_.skipConfigCheck():
      return False
   
   startLabel = label
   endLabel = label + rangeVal - 1
   # If we find a prefix segment with key other than 'prefix'
   # using this SID, it's a conflict
   instanceConfig = isisConfig.instanceConfig.get( instanceName )
   if instanceConfig:
      for key, value in instanceConfig.srPrefixSegments.items():
         # If the value to check is a label, only compare it to
         # other prefixes which have a label config
         if value.label != value.labelInvalid:
            if key.prefix != prefix or key.algoName != algoName:
               startVal = value.label
               endVal = value.label + value.range - 1
               # check if the two ranges overlap
               if startVal <= endLabel and endVal >= startLabel:
                  return True

   if instanceName == '':
      return False
   
   # Check for conflicts within an interface before the interface gets
   # added to isisConfig ( in cases where conflicting node segment labels are
   # configured before enabling IS-IS on the interface )
   if intfName and intfName not in isisConfig.intfConfig.items():
      srIntfConfig = _getSrIntfConfig( intfName )
      if ( srIntfConfig and 
           checkLabelConflictWithinInterface( srIntfConfig, startLabel, endLabel,
                                              ipv6 ) ):
         return True

   # Check for label conflicts within and across isis enabled interfaces
   for interface, intfConfig in isisConfig.intfConfig.items():
      if intfConfig.instanceName == intfConfig.instanceNameInvalid or \
            intfConfig.instanceName != instanceName:
         continue
      srIntfConfig = _getSrIntfConfig( interface )
      if srIntfConfig:
         if intfName and intfName == interface:
            if checkLabelConflictWithinInterface( srIntfConfig, startLabel, endLabel,
                                                  ipv6 ):
               return True
         else:
            if any( startLabel <= l <= endLabel
                    for l in srIntfConfig.srV4NodeSegmentLabel ):
               return True
            if any( startLabel <= l <= endLabel
                    for l in srIntfConfig.srV6NodeSegmentLabel ):
               return True
   return False

# This function is called by the file "RoutingIsisCliHandler.py" to get access
# to the conflict helper functions
def getConflictingConfigFoundDict():
   return {
      "prefixConflict" : _isisSrConflictingPrefixFound,
      "sidConflict" : _isisSrConflictingSidFound,
      "labelConflict" : _isisSrConflictingLabelFound
   }

#-------------------------------------------------------------------------------
# "[no|default] isis bfd"
# command, in config-if mode.
#-------------------------------------------------------------------------------
isisIntfBfdMatcher = CliMatcher.KeywordMatcher( 'bfd',
      helpdesc='Enable BFD' )

class IsisIntfBfdCmd( CliCommand.CliCommandClass ):
   syntax = 'isis bfd'
   noOrDefaultSyntax = syntax
   data = {
      'isis' : isisKw,
      'bfd' : isisIntfBfdMatcher
   }
   handler = "RoutingIsisCliHandler.setIntfBfdV4"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIntfBfdV4"

modelet.addCommandClass( IsisIntfBfdCmd )

#-------------------------------------------------------------------------------
# "[no|default] isis ipv6 bfd"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfIPV6BfdCmd( CliCommand.CliCommandClass ):
   syntax = 'isis ipv6 bfd'
   noOrDefaultSyntax = syntax
   data = {
      'isis' : isisKw,
      'ipv6' : isisIntfIpv6Matcher,
      'bfd' : isisIntfBfdMatcher
   }
   handler = "RoutingIsisCliHandler.setIntfBfdV6"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIntfBfdV6"

modelet.addCommandClass( IsisIntfIPV6BfdCmd )

def checkV4NodeSegmentConflict( intfName, instanceName, index ):
   ipIntfConfig = ipConfig.ipIntfConfig.get( intfName )

   if ipIntfConfig is not None:
      prefix = Arnet.IpGenPrefix( str( ipIntfConfig.addrWithMask.subnet ) )
      if _isisSrConflictingPrefixFound( instanceName, intfName,
                                        prefix, mode=None ):
         return ( False,
                  "Node-segment conflicts with a prefix/proxy segment" \
                  " configured for the prefix %s" % prefix )

   if _isisSrConflictingSidFound( instanceName, intfName, None, index ):
      return ( False,
               "Two prefixes cannot be configured with the same SID" )

   return ( True, None )

def checkV6NodeSegmentConflict( intfName, instanceName, index ):
   ip6IntfConfig = ip6Config.intf.get( intfName )
   if ip6IntfConfig:
      for prefix in ip6IntfConfig.addr:
         prefix = Arnet.IpGenPrefix( str( prefix ) )
         if _isisSrConflictingPrefixFound( instanceName, intfName,
                                           prefix, mode=None ):
            return ( False,
                     "Node-segment conflicts with a prefix/proxy segment" \
                     " configured for the prefix %s" % prefix )

   if _isisSrConflictingSidFound( instanceName, intfName, None, index ):
      return ( False,
               "Two prefixes cannot be configured with the same SID" )

   return ( True, None )

def checkNodeSegmentLabelConflict( instanceName, intfName, label, ipv6 ):
   if ipv6:
      ip6IntfConfig = ip6Config.intf.get( intfName )
      if ip6IntfConfig:
         for prefix in ip6IntfConfig.addr:
            prefix = Arnet.IpGenPrefix( str( prefix ) )
            if _isisSrConflictingPrefixFound( instanceName, intfName,
                                              prefix, mode=None ):
               return ( False,
                        "Node-segment conflicts with a prefix/proxy segment" \
                        " configured for the prefix %s" % prefix )
   else:
      ipIntfConfig = ipConfig.ipIntfConfig.get( intfName )
      if ipIntfConfig is not None:
         prefix = Arnet.IpGenPrefix( str( ipIntfConfig.addrWithMask.subnet ) )
         if _isisSrConflictingPrefixFound( instanceName, intfName,
                                           prefix, mode=None ):
            return ( False,
                     "Node-segment conflicts with a prefix/proxy segment" \
                     " configured for the prefix %s" % prefix )
   
   if _isisSrConflictingLabelFound( instanceName, intfName, None, label, ipv6 ):
      return ( False,
               "Two prefixes cannot be configured with the same label" )
   return ( True, None )

def checkNodeSegmentConflict( intfName, index=None, ipv6=False, label=None ):
   intfConfig = _getIntfConfig( intfName )
   if intfConfig:
      instanceName = intfConfig.instanceName
   else:
      instanceName = invalidInstanceName

   if label:
      return checkNodeSegmentLabelConflict( instanceName, intfName, label, ipv6 )
   if not ipv6:
      return checkV4NodeSegmentConflict( intfName, instanceName, index )
   else:
      return checkV6NodeSegmentConflict( intfName, instanceName, index )

#-------------------------------------------------------------------------------
# "[no|default] advertise high-metrics [include redistributed]
#                       [ on-startup ( DELAY | wait-for-bgp [timeout DELAY ] ) ]"
# command, in isis config mode.
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# "[no|default] graceful-restart" command, in isis config mode
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# "[no|default] graceful-restart-helper" command, in isis config mode
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# "[no|default] graceful-restart t2" command, in isis config mode
#-------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# "[no|default] graceful-restart restart-hold-time <n seconds>"
#  command in isis config mode
#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# "[no|default] database publish"  in 'router isis <>' mode
#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# "[no|default] advertise passive-only"  in 'router isis <>' mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] adjacency address-family match disabled" command, in isis config mode
#-------------------------------------------------------------------------------

#-----------------------------------------------------------------------------
#   [no|default] "metric <value>"
#   command, in 'address-family mode'
#----------------------------------------------------------------------------
# We don't support "metric maximum' because we can achieve
# the similar behavior through set overload bit

#-------------------------------------------------------------------------------
# [no|default] "fast-reroute ti-lfa mode ( ( PROTECTION [ LEVEL ] ) | disabled )"
# in 'address-family mode'
#-------------------------------------------------------------------------------
tilfaKw = CliMatcher.KeywordMatcher( 'ti-lfa', helpdesc='Configure TI-LFA FRR' )

class FrrRerouteExpression( CliCommand.CliExpression ):
   """Common syntax shared between the IS-IS address family mode configuration and
      the interface configuration."""
   expression = ( 'fast-reroute ti-lfa mode' +
                  ' ( ( PROTECTION [ LEVEL ] ) | ( disabled ... ) )' )
   data = {
      'fast-reroute' : 'Configure fast reroute',
      'ti-lfa' : tilfaKw,
      'mode' : 'Set mode',
      'PROTECTION' : CliMatcher.EnumMatcher( {
            'link-protection' : 'Protect against the failure of the link',
            'node-protection' : 'Protect against the failure of the neighbor node',
      } ),
      'LEVEL' : CliMatcher.EnumMatcher( {
            'level-1' : 'Protect prefixes in level-1 only',
            'level-2' : 'Protect prefixes in level-2 only',
      } ),
      'disabled' : 'Disable protection over the link',
   }


#-------------------------------------------------------------------------------
# "[no] fast-reroute ti-lfa srlg [strict]
# in 'address-family mode'
#-------------------------------------------------------------------------------
fastRerouteSrlgData = {
   'fast-reroute' : 'Configure fast reroute',
   'ti-lfa' : tilfaKw,
   'srlg' : "Exclude same SRLG links from backup path",
   'strict': "Apply strict SRLG constraint"
}
frrSrlgData = dict( fastRerouteSrlgData )


#-------------------------------------------------------------------------------
# [no|default] igp shortcut disabled
# in IPv4 'address family mode'
#-------------------------------------------------------------------------------


#-------------------------------------------------------------------------------
# [no|default] igp shortcut
# in IPv6 'address family mode'
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# [no|default] segment-routing ipv6
# in IPv6 'address family mode'
#-------------------------------------------------------------------------------
ipv6Kw = CliMatcher.KeywordMatcher( 'ipv6', helpdesc='IPv6 data plane' )


#-----------------------------------------------------------------------------------
# [no|default] next-hop tunnel rsvp < tunnel-name > prefix-list < prefix-list-name >
# in 'address family mode'
#-----------------------------------------------------------------------------------

# Can be extended to include other tunnel types in future


#-------------------------------------------------------------------------------
# "[no|default] set-overload-bit
#                  [on-startup <<delay> | wait-for-bgp [timeout <delay>]> ]"
# command, in isis config mode
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# "[no|default] isis hello padding"
# command, in config-if mode.
#-------------------------------------------------------------------------------
class IsisIntfHelloPaddingCmd( CliCommand.CliCommandClass ):
   if IsisToggleLib.toggleIsisIntfHelloPaddingDisableEnabled():
      syntax = 'isis hello padding [ disabled ]'
      noOrDefaultSyntax = 'isis hello padding ...'
   else:
      syntax = 'isis hello padding'
      noOrDefaultSyntax = syntax
   data = {
      'isis' : isisKw,
      'hello' : 'Configure hello packets on this interface',
      'padding' : 'Configure hello padding on this interface'
   }
   if IsisToggleLib.toggleIsisIntfHelloPaddingDisableEnabled():
      data[ 'disabled' ] = 'Disable hello padding on this interface'
   handler = "RoutingIsisCliHandler.setIsisIntfHelloPadding"
   noHandler = handler
   defaultHandler = "RoutingIsisCliHandler.defaultIsisIntfHelloPadding"

modelet.addCommandClass( IsisIntfHelloPaddingCmd )

#---------------------------------------------------------------------------------
# [no|default] adjacency-segment AF p2p [multiple]
# {<label <val>| index <val> global>} [backup-eligible]
#---------------------------------------------------------------------------------
class IsisIntfAdjacencySegmentConfigCmd( CliCommand.CliCommandClass ):
   syntax = 'adjacency-segment AF p2p [ multiple ] ' \
            '( label LABEL_VALUE ) | ( index INDEX_VALUE global )' \
            '[ backup-eligible ]'
   noOrDefaultSyntax = 'adjacency-segment AF p2p ( ( multiple ' \
                       '( label LABEL_VALUE ) | ( index INDEX_VALUE global ) )' \
                       '| ( label | index ) ) ...'
   data = {
      'adjacency-segment' : adjacencySegmentKw,
      'AF' : afMatcher,
      'p2p' : p2pKw,
      'multiple' : multipleKw,
      'label' : labelKw,
      'LABEL_VALUE' : labelValueMatcher,
      'index' : indexKw,
      'INDEX_VALUE' : indexValueMatcher,
      'global' : globalKw,
      'backup-eligible' : backupKw,
   }
   handler = "RoutingIsisCliHandler.setStaticAdjSid"
   noOrDefaultHandler = "RoutingIsisCliHandler.noStaticAdjSid"

modelet.addCommandClass( IsisIntfAdjacencySegmentConfigCmd )

#------------------------------------------------------------------------------
# [no|default] isis [ipv4|ipv6] route-tag <tag-no>   XXX: Hidden
#------------------------------------------------------------------------------
isisIntfIpv4Matcher = CliMatcher.KeywordMatcher( 'ipv4',
      helpdesc='IS-IS IPv4 interface config' )
isisIntfRouteTagMatcher = CliMatcher.KeywordMatcher( 'route-tag',
      helpdesc='Set a route-tag for the interface' )
isisIntfRouteTagValueMatcher = CliMatcher.IntegerMatcher(
      RouteTag.isisRouteTagMin,
      RouteTag.isisRouteTagMax,
      helpdesc='Route Tag Value' )

class IsisIntfIPV4RouteTagCmd( CliCommand.CliCommandClass ):
   syntax = 'isis ipv4 route-tag TAG_VALUE'
   noOrDefaultSyntax = 'isis ipv4 route-tag ...'
   data = {
      'isis' : isisKw,
      'ipv4' : CliCommand.Node( matcher=isisIntfIpv4Matcher, hidden=True ),
      'route-tag' : isisIntfRouteTagMatcher,
      'TAG_VALUE' : isisIntfRouteTagValueMatcher
   }
   handler = "RoutingIsisCliHandler.setIsisIntfRouteTagV4"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfRouteTagV4"

modelet.addCommandClass( IsisIntfIPV4RouteTagCmd )

class IsisIntfIPV6RouteTagCmd( CliCommand.CliCommandClass ):
   syntax = 'isis ipv6 route-tag TAG_VALUE'
   noOrDefaultSyntax = 'isis ipv6 route-tag ...'
   data = {
      'isis' : isisKw,
      'ipv6' : isisIntfIpv6Matcher,
      'route-tag' : CliCommand.Node( matcher=isisIntfRouteTagMatcher, hidden=True ),
      'TAG_VALUE' : isisIntfRouteTagValueMatcher
   }
   handler = "RoutingIsisCliHandler.setIsisIntfRouteTagV6"
   noOrDefaultHandler = "RoutingIsisCliHandler.noIsisIntfRouteTagV6"

modelet.addCommandClass( IsisIntfIPV6RouteTagCmd )

#-------------------------------------------------------------------------------
# [no|default] isis [ipv4|ipv6] fast-reroute ti-lfa mode ( {link-protection |
# node-protection} [ LEVEL ] | disabled )
#-------------------------------------------------------------------------------
class IsisIntfFrrProtectionCmd( CliCommand.CliCommandClass ):
   syntax = 'isis [ ipv4 | ipv6 ] FRR_REROUTE_EXPRESSION'
   noOrDefaultSyntax = 'isis [ ipv4 | ipv6 ] fast-reroute ti-lfa mode ...'
   data = {
      'isis': isisKw,
      'ipv4' : isisIntfIpv4Matcher,
      'ipv6' : isisIntfIpv6Matcher,
      'FRR_REROUTE_EXPRESSION' : FrrRerouteExpression,
   }

   handler = "RoutingIsisCliHandler.IsisIntfFrrProtectionCmd_handler"
   noOrDefaultHandler = \
             "RoutingIsisCliHandler.IsisIntfFrrProtectionCmd_noOrDefaultHandler"

modelet.addCommandClass( IsisIntfFrrProtectionCmd )

#-------------------------------------------------------------------------------
# [no|default] isis [ipv4|ipv6] fast-reroute ti-lfa srlg [strict] [disabled]
#-------------------------------------------------------------------------------
class IsisIntfFrrSrlgCmd( CliCommand.CliCommandClass ):
   syntax = '''isis [ ipv4 | ipv6 ] fast-reroute ti-lfa srlg [ strict ]
               [ disabled ]'''
   noOrDefaultSyntax = 'isis [ ipv4 | ipv6 ] fast-reroute ti-lfa srlg ...'
   data = dict( fastRerouteSrlgData )
   _intfData = {
      'isis': isisKw,
      'ipv4' : isisIntfIpv4Matcher,
      'ipv6' : isisIntfIpv6Matcher,
      'disabled' : "Disable SRLG protection for the link"
   }
   data.update( _intfData )

   handler = "RoutingIsisCliHandler.IsisIntfFrrSrlgCmd_handler"
   noOrDefaultHandler = "RoutingIsisCliHandler.IsisIntfFrrSrlgCmd_noOrDefaultHandler"

modelet.addCommandClass( IsisIntfFrrSrlgCmd )

#-------------------------------------------------------------------------------
# New Cli Parser
#-------------------------------------------------------------------------------
def isisShowCommandSyntaxWrapper( cmd ):
   '''
   IS-IS show command CLIs can be of two forms:
   show isis [ INSTANCE_NAME ] COMMAND [ ARGS ]
   or
   show isis COMMAND [ ARGS ] [ vrf VRF_NAME ]

   If instance name is specified, we show the information for that instance.
   We do not allow both instance name and vrf name to be specified.
   '''
   template = 'show isis ( %s ) | ( INSTANCE %s ) | ( %s vrf VRFNAME )'
   return template % ( cmd, cmd, cmd )

def isisClearCommandSytaxWrapper( cmd ):
   '''
   IS-IS clear command CLIs can be of two forms:
   clear isis [ INSTANCE_NAME ] COMMAND [ ARGS ]
   or
   clear isis COMMAND [ ARGS ] [ vrf VRF_NAME ]

   If instance name is specified, we clear the information for that instance.
   We do not allow both instance name and vrf name to be specified.
   '''
   template = "clear isis ( [ INSTANCE | ALL_INSTANCE ] %s ) | ( %s vrf VRFNAME )"
   return template % ( cmd, cmd )

isisInstanceMatcher = CliMatcher.DynamicKeywordMatcher(
   lambda mode : isisConfig.instanceConfig,
   priority=CliParser.PRIO_HIGH,
   emptyTokenCompletion=[ CliParser.Completion( 'NAME',
                                               'Name of the IS-IS protocol instance',
                                               literal=False ) ] )

allInstanceMatcher = CliMatcher.KeywordMatcher(
   'all', helpdesc='Clear the state in all IS-IS instances in the default VRF',
   priority=CliParser.PRIO_LOW )

vrfNameMatcher = CliMatcher.DynamicNameMatcher(
   VrfCli.getAllPlusReservedVrfNames, helpdesc='VRF name' )

def getIsisConfigAndStatus( mode, instanceId, instanceName ):
   if not instanceName:
      mode.addError( "Invalid IS-IS instance name" )
      return None, None

   instConfig = isisConfig.instanceConfig[ instanceName ]

   if not instConfig:
      mode.addError( "IS-IS (%s) Can not find configuration" % instanceName )
      return None, None

   isisStatus = isisStatusDir.get( instConfig.vrfName )
   instStatus = isisStatus.instanceStatus[ instanceName ]
   if not instStatus:
      mode.addError( "IS-IS (%s) Can not find status data" % instanceName )
      return None, None

   if instConfig.shutdown:
      return None, None

   return instConfig, instStatus

#-------------------------------------------------------------------------------
# Show commands
#-------------------------------------------------------------------------------

# show isis [ INSTANCE ] interface [ detail ]
# show isis interface intf [ detail ]
class ShowIsisInterfaceCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'interface [ detail | brief ]' ) + \
            ' | ( interface intf [ detail | brief ] )'
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'interface' : 'IS-IS interface status',
      'intf' : IntfCli.Intf.matcher,
      'detail' : detailKw,
      'brief' : briefKw,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.interfaceVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisInterfaceCmd_handler"

BasicCli.addShowCommandClass( ShowIsisInterfaceCmd )

#-------------------------------------------------------------------------------
# show isis summary
#-------------------------------------------------------------------------------
class ShowIsisSummaryCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'summary' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'summary' : 'Get summary information for IS-IS',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisSummaryVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisSummaryCmd_handler"

BasicCli.addShowCommandClass( ShowIsisSummaryCmd )

class ShowIsisLeakedRouteSumAddrCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'summary-address [ detail ]' )
   data = {
         'isis' : isisKw,
         'INSTANCE' : isisInstanceMatcher,
         'summary-address' : 'Summary route configuration',
         'detail' : detailKw,
         'vrf' : vrfKw,
         'VRFNAME' : vrfNameMatcher
         }
   cliModel = IsisCliModels.isisLeakedRouteSumAddrVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisLeakedRouteSumAddrCmd_handler"

BasicCli.addShowCommandClass( ShowIsisLeakedRouteSumAddrCmd )

#-------------------------------------------------------------------------------
# show isis database [ detail | traffic-engineering ] [ LEVEL ] [lspid]
#-------------------------------------------------------------------------------
# Acceptable forms:
# 'show isis database [ LEVEL ] [ lspid ]'
# 'show isis database [ lspid ] [ LEVEL ]'
class ShowIsisDatabaseCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'database [ { LEVEL | LSPID } ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE': isisInstanceMatcher,
      'database': dbKw,
      'LEVEL' : singleLevelNodeForShow,
      'LSPID' : singleLspidNode,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.lspDbSummaryVRFModel

   handler = "RoutingIsisCliHandler.ShowIsisDatabaseCmd_handler"

BasicCli.addShowCommandClass( ShowIsisDatabaseCmd )

# Acceptable forms:
# 'show isis database { ( detail|traffic-engineering ) [ LEVEL ] [ lspid ] }'
class ShowIsisDatabaseTeOrDetailCmd( ShowCommand.ShowCliCommandClass ):
   # This syntax must allow at least one argument after
   # 'show isis database' which can neither be only level-1
   # nor only level-2 nor only <lspid>, i.e., either 'detail'
   # or 'traffic-engineering' must be used or else it would
   # cause an ambiguity. It must also be noted that 'detail'
   # or 'traffic-engineering' may be entered in any sequence,
   # i.e., before/after <level> or <lspid> or both.

   syntax = isisShowCommandSyntaxWrapper(
         'database [ { LEVEL | LSPID } ] '
         '( detail | traffic-engineering ) [ { LEVEL | LSPID } ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'database' : CliCommand.Node( matcher=dbKw, maxMatches=1 ),
      'traffic-engineering' : 'Traffic-engineering information',
      'LEVEL' : singleLevelNodeForShow,
      'detail' : detailKw,
      'LSPID' : singleLspidNode,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.lspDbVRFModel

   handler = "RoutingIsisCliHandler.ShowIsisDatabaseTeOrDetailCmd_handler"

BasicCli.addShowCommandClass( ShowIsisDatabaseTeOrDetailCmd )

# -------------------------------------------------------------------------------
# show isis database detail [ LEVEL ] [lspid] tlv
# -------------------------------------------------------------------------------
class ShowIsisDatabaseDetailTlvCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper(
       'database detail [ { LEVEL | LSPID } ] tlv' )
   data = {
      'isis': isisKw,
      'INSTANCE': isisInstanceMatcher,
      'database': CliCommand.Node( matcher=dbKw, maxMatches=1 ),
      'detail': detailKw,
      'LEVEL': singleLevelNodeForShow,
      'LSPID': singleLspidNode,
      'vrf': vrfKw,
      'VRFNAME': vrfNameMatcher,
      'tlv': 'Display TLV Information'
   }
   cliModel = IsisCliModels.lspDbDetailTlvVRFModel
   handler = "RoutingIsisCliHandler.ShowIsisDatabaseDetailTlvCmd_handler"

if IsisToggleLib.toggleShowIsisDatabaseDetailTlvEnabled():
   BasicCli.addShowCommandClass( ShowIsisDatabaseDetailTlvCmd )


#------------------------------------------------
#  show isis lsp log
#------------------------------------------------
class ShowIsisLspLogCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'lsp log' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'lsp' : 'IS-IS LSP information',
      'log' : 'IS-IS LSP log',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.lspLogTableVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisLspLogCmd_handler"

BasicCli.addShowCommandClass( ShowIsisLspLogCmd )

#-------------------------------------------------------------------------------
# show isis neighbors [detail] [ LEVEL ]
#-------------------------------------------------------------------------------
class ShowIsisNeighborCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'neighbors [ { [ detail ] [ LEVEL ] } ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'LEVEL' : singleLevelNodeForShow,
      'neighbors' : 'Protocol neighbor details',
      'detail' : CliCommand.Node( matcher=detailKw, maxMatches=1 ),
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.showNeighborTableVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisNeighborCmd_handler"

BasicCli.addShowCommandClass( ShowIsisNeighborCmd )

#-------------------------------------------------------------------------------
# show isis network topology
#
# legacy:
# show isis topology
#-------------------------------------------------------------------------------
class ShowIsisNetworkTopologyCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper(
      'network topology [ LEVEL ] [ ldp-tunneling ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'network' : 'IS-IS network information',
      'topology' : topologyKw,
      'LEVEL' : levelMatcherForShow,
      'ldp-tunneling' : 'Information for LDP over RSVP SPF',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisTopologyVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisNetworkTopologyCmd_handler"

BasicCli.addShowCommandClass( ShowIsisNetworkTopologyCmd )

class ShowIsisTopologyCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'topology [ LEVEL ] ' )
   _deprecatedByCmd = 'show isis network topology [ LEVEL ]'
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'topology' : CliCommand.Node( matcher=topologyKw,
                                    deprecatedByCmd=_deprecatedByCmd ),
      'LEVEL' : levelMatcherForShow,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisTopologyVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisTopologyCmd_handler"

BasicCli.addShowCommandClass( ShowIsisTopologyCmd )

#-------------------------------------------------------------------------------
# show isis spf log [ LEVEL ]
#-------------------------------------------------------------------------------
class ShowIsisSpfLogCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'spf log [ tunneling ldp ] [ LEVEL ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'spf' : 'IS-IS SPF Information',
      'log' : 'IS-IS SPF logs',
      'LEVEL' : levelMatcherForShow,
      'tunneling' : 'Tunneling LDP SPF logs',
      'ldp' : 'Tunneling LDP SPF logs',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.spfLogTableVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisSpfLogCmd_handler"

BasicCli.addShowCommandClass( ShowIsisSpfLogCmd )

#-------------------------------------------------------------------------------
# show isis lsp purges [ LEVEL ]
#-------------------------------------------------------------------------------
class ShowIsisLspPurgesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'lsp purges [ LEVEL ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'lsp' : lspKwForShow,
      'purges' : 'IS-IS purge log',
      'LEVEL' : levelMatcherForShow,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisLspPurgesVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisLspPurgesCmd_handler"

BasicCli.addShowCommandClass( ShowIsisLspPurgesCmd )

#-------------------------------------------------------------------------------
# show isis graceful-restart
#-------------------------------------------------------------------------------
class ShowIsisGracefulRestartCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'graceful-restart' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'graceful-restart' : 'Graceful Restart information',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisGracefulRestartVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisGracefulRestartCmd_handler"

BasicCli.addShowCommandClass( ShowIsisGracefulRestartCmd )

#-------------------------------------------------------------------------------
# show isis local-convergence-delay [detail]
#-------------------------------------------------------------------------------
class ShowIsisLocalConvergenceDelayCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'local-convergence-delay [ detail ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'local-convergence-delay' : 'Micro-loop local convergence delay information',
      'detail' : detailKw,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisUloopVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisLocalConvergenceDelayCmd_handler"

BasicCli.addShowCommandClass( ShowIsisLocalConvergenceDelayCmd )

#-------------------------------------------------------------------------------
# show isis dynamic flooding [ LEVEL ] nodes [<node id>]
#-------------------------------------------------------------------------------
trailingByte = r'\.[0-9a-fA-F]{2}'
trailingRegEx = trailingByte + '$'
nodeIdRegex = hostnameRegex + '(' + trailingByte + ')?'
nodeIdMatcher = CliMatcher.PatternMatcher( nodeIdRegex, helpname='node',
                                  helpdesc='Node ID in HHHH.HHHH.HHHH.HH or '
                                  'hostname.HH format' )

class ShowIsisDynFloodNode( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper(
      'dynamic flooding [ LEVEL ] nodes [NODENAME]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'dynamic' : 'Dynamic flooding information',
      'flooding' : 'Dynamic flooding information',
      'LEVEL' : levelMatcherForShow,
      'nodes' : 'Nodes in the flooding topology',
      'NODENAME' : nodeIdMatcher,
      'vrf' : 'vrf name',
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisDynFloodNodeVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisDynFloodNode_handler"

BasicCli.addShowCommandClass( ShowIsisDynFloodNode )

#-------------------------------------------------------------------------------
# show isis dynamic flooding [ LEVEL ] paths
#-------------------------------------------------------------------------------

class ShowIsisDynFloodPaths( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper(
      'dynamic flooding [ LEVEL ] paths' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'dynamic' : 'Dynamic flooding information',
      'flooding' : 'Dynamic flooding information',
      'LEVEL' : levelMatcherForShow,
      'paths' : 'Paths in the flooding topology',
      'vrf' : 'vrf name',
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisDynFloodPathsVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisDynFloodPaths_handler"

BasicCli.addShowCommandClass( ShowIsisDynFloodPaths )

#-------------------------------------------------------------------------------
# show isis dynamic flooding [ LEVEL ] topology
#-------------------------------------------------------------------------------

class ShowIsisDynFloodTopology( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper(
      'dynamic flooding [ LEVEL ] topology' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'dynamic' : 'Dynamic flooding information',
      'flooding' : 'Dynamic flooding information',
      'LEVEL' : levelMatcherForShow,
      'topology' : 'Flooding topology',
      'vrf' : 'vrf name',
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisDynFloodTopologyVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisDynFloodTopology_handler"

BasicCli.addShowCommandClass( ShowIsisDynFloodTopology )

#-------------------------------------------------------------------------------
# show isis dynamic flooding [ LEVEL ] interfaces
#-------------------------------------------------------------------------------

class ShowIsisDynFloodInterfaces( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper(
      'dynamic flooding [ LEVEL ] interfaces' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'dynamic' : 'Dynamic flooding information',
      'flooding' : 'Dynamic flooding information',
      'LEVEL' : levelMatcherForShow,
      'interfaces' : 'Flooding interfaces',
      'vrf' : 'vrf name',
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisDynFloodInterfacesVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisDynFloodInterfaces_handler"

BasicCli.addShowCommandClass( ShowIsisDynFloodInterfaces )

#------------------------------------------------------------------------------
# Area proxy show commands
#
# show isis area proxy
#------------------------------------------------------------------------------

class ShowIsisAreaProxy( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'area proxy' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'area' : 'Area information',
      'proxy' : 'Area proxy information',
      'vrf' : 'vrf name',
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisShowAreaProxyVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisAreaProxy_handler"

BasicCli.addShowCommandClass( ShowIsisAreaProxy )

#-------------------------------------------------------------------------------
# Flex Algo Show commands
#
# show isis flex-algo
#    [ { ( algorithm NAME ) | ( system SYSTEM ) | LEVEL |
#          advertised | routers } ]
#
# Funkiness warning: the algorithm, system, and level can always be specified.
# Routers is both a qualifier and a stand-alone command.
# Ordering is not important.
# If an algorithm name is specified then we return details.
# If 'routers' is specified alone, then we issue that command, otherwise, we
# request a summary.
#-------------------------------------------------------------------------------

# Helper function used by the CLI models
def flexAlgoIdToName( algoId ):
   defin = flexAlgoConfig.definition.get( algoId )
   return defin.name if defin else str( algoId )

flexAlgoAlgorithmKw = CliCommand.singleNode(
   CliMatcher.KeywordMatcher( 'algorithm', helpdesc='Specify an algorithm' ) )
flexAlgoName = CliMatcher.PatternMatcher( namePattern,
                                          helpname='WORD',
                                          helpdesc='Algorithm Name' )
flexAlgoSystemKw = CliCommand.singleNode(
   CliMatcher.KeywordMatcher( 'system', helpdesc='Specify a system' ) )
systemRegex = r"[A-Za-z0-9,_:\-\./#%+]{1,255}"
flexAlgoSystem = CliMatcher.PatternMatcher(
      pattern=systemRegex,
      helpdesc='System Id in HHHH.HHHH.HHHH format or hostname',
      helpname='SYSTEM' )

flexAlgoKwObj = object()
flexAlgoAdvertisedKw = CliCommand.singleNode(
   CliMatcher.KeywordMatcher(
      'advertised',
      helpdesc='Advertised algorithm definitions' ),
   sharedMatchObj=flexAlgoKwObj )
flexAlgoRoutersKw = CliCommand.singleNode(
   CliMatcher.KeywordMatcher(
      'routers', helpdesc='Routers participating in this algorithm' ),
   sharedMatchObj=flexAlgoKwObj )

class ShowIsisFlexAlgo ( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper(
      'flex-algo [ { ( algorithm NAME ) | ( system SYSTEM ) | LEVEL '
      ' | advertised | routers } ]' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'vrf' : 'vrf name',
      'VRFNAME' : vrfNameMatcher,
      'flex-algo' : 'Flexible algorithm',
      'algorithm' : flexAlgoAlgorithmKw,
      'NAME' : flexAlgoName,
      'system' : flexAlgoSystemKw,
      'SYSTEM' : flexAlgoSystem,
      'LEVEL' : singleLevelNodeForShow,
      'advertised' : flexAlgoAdvertisedKw,
      'routers' : flexAlgoRoutersKw,
   }
   cliModel = IsisCliModels.isisShowFlexAlgoVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisFlexAlgo_handler"

BasicCli.addShowCommandClass( ShowIsisFlexAlgo )

#-------------------------------------------------------------------------------
# Segment Routing Show Commands
#-------------------------------------------------------------------------------
def isisSrIsActive( mode, instanceName ):
   instConfig = isisConfig.instanceConfig[ instanceName ]
   srSysdbStatus = srSysdbStatusDir.get( 'default' )
   if not srSysdbStatus:
      return False

   if instConfig.srEnabled == instConfig.srEnabledDefault:
      mode.addWarning( "IS-IS (Instance: %s) Segment Routing has been " \
            "administratively shutdown" % instanceName )
      return False

   if mplsRoutingConfig.mplsRouting == False:
      mode.addWarning( "Mpls routing is not enabled" )
      return False

   if str( srSysdbStatus.igpRtrId ) == str( instConfig.routerIdV4Default ):
      mode.addWarning( "IS-IS (Instance: %s) Segment Routing is disabled because " \
            "the Router ID is not configured" % instanceName )
      return False
   return True

#helper function for the below used functions which returns hostnames
#from the isisSystemIdHostname map in srSysdbStatus whenever present
def getHostName( rId, vrfName="default" ):
   smi = SmashLazyMount.mountInfo( 'reader' )
   path = 'routing/isis/hostnamemap/%s' % vrfName
   if vrfName == 'default':
      isisHostnameMap = isisSystemIdHostnameMap
   else:
      isisHostnameMap = SmashLazyMount.mount(
            entityManager, path, 'IsisExportImpl::IsisHostnameMap', smi,
            autoUnmount = True )
   hostname = None
   hostnameArray = isisHostnameMap.hostnameMap.get( rId )
   if hostnameArray:
      hostname = hostnameArray.smashString()

   return hostname

def getFlexAlgoName( flexAlgoId ):
   if flexAlgoId == 0:
      return IsisCliHelper.SR_ALGO_SPF
   if flexAlgoId == 1:
      return IsisCliHelper.SR_ALGO_SSPF
   if flexAlgoConfig and flexAlgoId:
      name = flexAlgoConfig.flexAlgoName( flexAlgoId )
      if name is not None:
         return name
   if flexAlgoId >= 128 and flexAlgoId <= 255: # pylint: disable=chained-comparison
      return IsisCliHelper.SR_ALGO_USER_DEFINED
   return IsisCliHelper.SR_ALGO_UNDEFINED

def getSharedSecretProfileNameIntf( intfName, level ):
   intfConfig = _getIntfConfig( DeviceNameLib.intfLongName( intfName ) )
   if intfConfig is not None:
      if level == 1:
         return intfConfig.sharedSecretProfileNameL1
      else:
         return intfConfig.sharedSecretProfileNameL2

def getSharedSecretProfileName( instanceName, level ):
   if instanceName and isisConfig:
      instConfig = isisConfig.instanceConfig[ instanceName ]
      if instConfig is not None:
         if level == 1:
            return instConfig.sharedSecretProfileNameL1
         else:
            return instConfig.sharedSecretProfileNameL2

class ShowIsisMplsSrBindings( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mpls segment-routing bindings ' \
            '[ ( IPADDR | IP6ADDR ) | ( ipv4 | ipv6 ) ] ' \
            '[ detail ]'
   data = {
      'mpls' : mplsNodeForShow,
      'segment-routing' : 'Segment Routing Information',
      'bindings' : 'Label bindings',
      'IPADDR' : ipv4IPMatcher,
      'IP6ADDR' : ipv6IPMatcher,
      'ipv4' : 'IS-IS SR IPv4 bindings',
      'ipv6' : 'IS-IS SR IPv6 bindings',
      'detail' : 'Display information in detail'
   }
   handler = "RoutingIsisCliHandler.showMplsSrBindings"
   cliModel = MplsModel.MplsBindingsModel

BasicCli.addShowCommandClass( ShowIsisMplsSrBindings )

#-------------------------------------------------------------------------------
# show isis mpls ldp sync [interface]
#-------------------------------------------------------------------------------
#
# ldpConfigColl is mounted at mpls/ldp/ldpConfigColl of Ldp::LdpConfigColl
#
# ldpProtoConfigColl is mounted at mpls/ldp/ldpProtoConfigColl of
# Ldp::LdpProtoConfigColl
#
# linkReadyStatusVrfColl is mounted at mpls/ldp/linkReadyStatus of
# Ldp::LdpLinkReadyStatusVrfColl
#
# instanceLevelConfig is instance-level mpls ldp sync config value (a boolean)
#
igpSyncMatcher = CliMatcher.KeywordMatcher( 'sync',
      helpdesc='IGP sync configuration' )
ldpMatcher = CliMatcher.KeywordMatcher( 'ldp',
      helpdesc='LDP configuration' )
class ShowIsisMplsLdpSyncCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show isis [ INSTANCE ] mpls ldp sync [ intf ]'
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'mpls' : mplsForShowNode,
      'ldp': ldpMatcher,
      'sync': igpSyncMatcher,
      'intf' : IntfCli.Intf.matcher,
   }

   cliModel = IsisCliModels.isisMplsLdpSyncVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisMplsLdpSyncCmd_handler"

BasicCli.addShowCommandClass( ShowIsisMplsLdpSyncCmd )

#-------------------------------------------------------------------------------
# show isis hostname
#-------------------------------------------------------------------------------
class ShowIsisHostnameCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'hostname' )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'hostname' : 'System ID to hostname mapping',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.isisHostnameVRFModel

   handler = "RoutingIsisCliHandler.ShowIsisHostnameCmd_handler"

BasicCli.addShowCommandClass( ShowIsisHostnameCmd )

#-------------------------------------------------------------------------------
# show isis counters [ packet | drop | system ]
# show isis counters [ drop ] details
#-------------------------------------------------------------------------------
class ShowIsisCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( '''counters [ packet
                                                      | system
                                                      | ( drop [ details ] )
                                                      | ( details [ drop ] ) ]'''
   )
   data = {
      'isis' : isisKw,
      'INSTANCE' : isisInstanceMatcher,
      'counters' : 'Show IS-IS Packet counters, Drop counters and System counters',
      'packet' : 'Show only the packet counters',
      'drop' : 'Show only the drop counters',
      'system' : 'Show only the system counters',
      'details' : 'Show IS-IS Packet, Drop and System counters with drop details',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisCliModels.showCountersVRFsModel

   handler = "RoutingIsisCliHandler.ShowIsisCountersCmd_handler"

BasicCli.addShowCommandClass( ShowIsisCountersCmd )

#-------------------------------------------------------------------------------
# show isis ti-lfa tunnel [ TUNNEL_INDEX ]
#-------------------------------------------------------------------------------
class ShowIsisTilfaTunnelTableCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show isis ti-lfa tunnel [ TUNNEL_INDEX ]'
   data = {
      'isis' : isisKw,
      'ti-lfa': tokenTilfaForShow,
      'tunnel': tokenTunnelMatcher,
      'TUNNEL_INDEX': tunnelIndexMatcher
   }
   cliModel = TilfaTunnelTable

   handler = "RoutingIsisCliHandler.ShowIsisTilfaTunnelTableCmd_handler"

BasicCli.addShowCommandClass( ShowIsisTilfaTunnelTableCmd )

#-------------------------------------------------------------------------------
# Clear commands
#-------------------------------------------------------------------------------
NbrIdRegex = "^(?!all$)" + notAPrefixOf( 'interface' ) + hostnameRegex
NbrIdMatcher = CliMatcher.PatternMatcher( pattern=NbrIdRegex,
                                        helpdesc='System-ID or hostname of neighbor',
                                        helpname='Neighbor-ID' )
class ClearIsisNeighborCmd( CliCommand.CliCommandClass ):
   syntax = (
         isisClearCommandSytaxWrapper( 'neighbor ( Neighbor-ID | all ) [ LEVEL ]' ) +
         '| ( neighbor [ Neighbor-ID ] interface INTF [ LEVEL ] )' )
   data = {
      'clear' : CliToken.Clear.clearKwNode,
      'isis' : clearIsisKw,
      'INSTANCE' : isisInstanceMatcher,
      'ALL_INSTANCE' : allInstanceMatcher,
      'neighbor' : 'Reset neighbors',
      'Neighbor-ID' : CliCommand.Node( matcher=NbrIdMatcher, maxMatches=1 ),
      'all' : 'Clear all',
      'interface' : 'Reset neighbors on an interface',
      'INTF' : IntfCli.Intf.matcher,
      'LEVEL' : CliMatcher.EnumMatcher( {
         'level-1' : 'Level 1 only',
         'level-2' : 'Level 2 only',
         'level-1-2' : 'Level 1-2 Point-to-Point only',
      } ),
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }

   handler = "RoutingIsisCliHandler.ClearIsisNeighborCmd_handler"

BasicCli.EnableMode.addCommandClass( ClearIsisNeighborCmd )

#-------------------------------------------------------------------------------
# "clear isis instance
#-------------------------------------------------------------------------------
class ClearIsisInstanceCmd( CliCommand.CliCommandClass ):
   syntax = isisClearCommandSytaxWrapper( 'instance' )
   data = {
      'clear' : CliToken.Clear.clearKwNode,
      'isis' : clearIsisKw,
      'INSTANCE' : isisInstanceMatcher,
      'ALL_INSTANCE' : allInstanceMatcher,
      'instance' : 'Reset instance',
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }

   handler = "RoutingIsisCliHandler.ClearIsisInstanceCmd_handler"

BasicCli.EnableMode.addCommandClass( ClearIsisInstanceCmd )

#-------------------------------------------------------------------------------
# clear isis counters
#-------------------------------------------------------------------------------
class ClearIsisCountersCmd( CliCommand.CliCommandClass ):
   syntax = isisClearCommandSytaxWrapper( 'counters' ) + \
            ' | ( counters interface INTF )'
   data = {
      'clear' : CliToken.Clear.clearKwNode,
      'isis' : clearIsisKw,
      'INSTANCE' : isisInstanceMatcher,
      'ALL_INSTANCE' : allInstanceMatcher,
      'counters' : 'Reset counters',
      'interface' : 'Reset counters on an interface',
      'INTF' : IntfCli.Intf.matcher,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher
   }

   handler = "RoutingIsisCliHandler.ClearIsisCountersCmd_handler"

BasicCli.EnableMode.addCommandClass( ClearIsisCountersCmd )

#-------------------------------------------------------------------------------
# clear isis database
#-------------------------------------------------------------------------------
class ClearIsisDatabaseCmd( CliCommand.CliCommandClass ):
   _dbClearSyntax = 'database ( all | { LSPID | LEVEL } ) [ domain-wide-purge ]'
   syntax = isisClearCommandSytaxWrapper( _dbClearSyntax )
   data = {
      'clear' : CliToken.Clear.clearKwNode,
      'isis' : clearIsisKw,
      'INSTANCE' : isisInstanceMatcher,
      'ALL_INSTANCE' : allInstanceMatcher,
      'database' : 'Reset database',
      'all' : 'All',
      'LEVEL' : singleLevelNodeForShow,
      'LSPID' : singleLspidNode,
      'domain-wide-purge' : domainWidePurgeKw,
      'vrf' : vrfKw,
      'VRFNAME' : vrfNameMatcher,
   }

   handler = "RoutingIsisCliHandler.ClearIsisDatabaseCmd_handler"

BasicCli.EnableMode.addCommandClass( ClearIsisDatabaseCmd )

class IsisRouteMapReferenceGatherer:
   """
   This class gathers references to route maps in commands under
   the 'router isis' mode.
   """
   @staticmethod
   def gather( feature ):
      references = set()
      gatherer = IsisRouteMapReferenceGatherer
      for instanceName in isisConfig.instanceConfig:
         instanceConfig = isisConfig.instanceConfig[ instanceName ]
         gatherer.gatherRefsInRedistributeConfig( instanceConfig, references )
         gatherer.gatherRefsInLeakRouteMapConfig( instanceConfig, references )
         gatherer.gatherRefsInAttachBitConfig( instanceConfig, references )
      return references

   @staticmethod
   def gatherRefsInRedistributeConfig( instanceConfig, references ):
      redistConfigNames = [ 'redistributeConfig', 'redistributeConfigV4',
                            'redistributeConfigV6' ]
      for redistConfigName in redistConfigNames:
         redistConfig = getattr( instanceConfig, redistConfigName )
         for proto in redistConfig:
            redistribute = redistConfig[ proto ]
            routeMap = redistribute.routeMap
            if routeMap:
               references.add( routeMap )

   @staticmethod
   def gatherRefsInLeakRouteMapConfig( instanceConfig, references ):
      leakRouteMapAttrs = [ 'leakRouteMapL1ToL2V4', 'leakRouteMapL1ToL2V6',
                            'leakRouteMapL2ToL1V4', 'leakRouteMapL2ToL1V6' ]
      for leakRouteMapAttr in leakRouteMapAttrs:
         routeMap = getattr( instanceConfig, leakRouteMapAttr )
         if routeMap:
            references.add( routeMap )

   @staticmethod
   def gatherRefsInAttachBitConfig( instanceConfig, references ):
      routeMap = instanceConfig.attachBitRouteMap
      if routeMap:
         references.add( routeMap )

UndefinedReferenceChecker.addReferenceGatherer(
      [ "Route map" ], IsisRouteMapReferenceGatherer )


#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entMan ):
   global routingHardwareStatusCommon
   global routingHardwareStatus
   global isisConfig, isisStatusDir, routingHardwareStatus
   global routing6Config, routing6HardwareStatus, allIntfStatusDir
   global ipConfig, ip6Config
   global isisClearReqDir, isisClearRespDir
   global vrfInfoDir, vrf6InfoDir, srSysdbStatusDir
   global linkReadyStatusVrfColl, ldpProtoConfigColl, ldpConfigColl
   global entityManager
   global mplsRoutingConfig
   global l3Config
   global mplsStatus
   global isisSystemIdHostnameMap
   global tilfaTunnelTable
   global isisSrV4BindingTable
   global isisSrV6BindingTable
   global srConfig
   global trapConfig
   global flexAlgoConfig
   global teConfig
   global sharedSecretConfig
   global filteredRibStatus

   entityManager = entMan
   shmemEm = SharedMem.entityManager( sysdbEm=entityManager )
   smi = Smash.mountInfo( 'reader' )

   l3Config = ConfigMount.mount( entityManager, "l3/config", "L3::Config", 'w' )
   tilfaTunnelTable = readMountTunnelTable(
      TunnelTableIdentifier.tiLfaTunnelTable, entityManager )
   isisConfig = ConfigMount.mount( entityManager, 'routing/isis/config',
                                   'Routing::Isis::Config', 'w' )
   isisStatusDir = LazyMount.mount( entityManager, 'routing/isis/status',
                                    'Tac::Dir', 'ri' )
   isisClearReqDir = LazyMount.mount( entityManager, 'routing/isis/clear/request',
                                      'Routing::Isis::ClearRequestNode', 'w' )
   isisClearRespDir = LazyMount.mount( entityManager, 'routing/isis/clear/response',
                                       'Tac::Dir', 'ri' )
   ipConfig = LazyMount.mount( entityManager, "ip/config", "Ip::Config", "r" )
   ip6Config = LazyMount.mount( entityManager, "ip6/config", "Ip6::Config", "r" )
   routingHardwareStatusCommon = LazyMount.mount(
      entityManager, "routing/hardware/statuscommon",
      "Routing::Hardware::StatusCommon", "r" )
   routingHardwareStatus = LazyMount.mount( entityManager, "routing/hardware/status",
                                            "Routing::Hardware::Status", "r" )
   routing6Config = LazyMount.mount( entityManager, "routing6/config",
                                     "Routing6::Config", "r" )
   routing6HardwareStatus = LazyMount.mount( entityManager,
                                             "routing6/hardware/status",
                                             "Routing6::Hardware::Status", "r" )
   srSysdbStatusDir = LazyMount.mount( entityManager,
                                    "segmentrouting/isis",
                                    "Tac::Dir", "ri" )
   allIntfStatusDir = LazyMount.mount( entityManager, "interface/status/all",
                                       "Interface::AllIntfStatusDir", "r" )
   vrfInfoDir = LazyMount.mount( entityManager, "routing/vrf/routingInfo/status",
                                "Tac::Dir", "ri" )
   vrf6InfoDir = LazyMount.mount( entityManager, "routing6/vrf/routingInfo/status",
                                "Tac::Dir", "ri" )
   linkReadyStatusVrfColl = LazyMount.mount( entityManager,
                                  "mpls/ldp/linkReadyStatus",
                                  "Ldp::LdpLinkReadyStatusVrfColl", "r" )
   ldpProtoConfigColl = LazyMount.mount( entityManager,
                                         "mpls/ldp/ldpProtoConfigColl",
                                         "Ldp::LdpProtoConfigColl", "r" )
   ldpConfigColl = LazyMount.mount( entityManager,
                                    "mpls/ldp/ldpConfigColl",
                                    "Ldp::LdpConfigColl", "r" )
   mplsRoutingConfig = LazyMount.mount( entityManager, 'routing/mpls/config',
                                                      "Mpls::Config", "r" )
   mplsStatus = LazyMount.mount( entityManager, 'mpls/status',
                                 "Mpls::Api::Status", "r" )
   isisSystemIdHostnameMap = shmemEm.doMount( 'routing/isis/hostnamemap/default',
                                              "IsisExportImpl::IsisHostnameMap",
                                              smi )
   isisSrV4BindingTable = shmemEm.doMount( "mpls/labelBindingTables/isisV4",
                                           "CommonLibSmash::LabelBindingTable",
                                           Smash.mountInfo( 'keyshadow' ) )
   isisSrV6BindingTable = shmemEm.doMount( "mpls/labelBindingTables/isisV6",
                                           "CommonLibSmash::LabelBindingTable",
                                           Smash.mountInfo( 'keyshadow' ) )
   srConfig = ConfigMount.mount( entityManager, "routing/sr/config",
                                 "Routing::SegmentRoutingCli::Config", 'w' )
   trapConfig = ConfigMount.mount( entityManager, "hardware/trap/config/trapConfig",
                                   "Arnet::TrapConfig", 'w' )
   flexAlgoConfig = LazyMount.mount( entityManager, 'te/flexalgo/config',
                                     'FlexAlgo::Config', 'r' )
   teConfig = LazyMount.mount( entityManager, 'te/config',
                               'TrafficEngineering::Config', 'r' )
   sharedSecretConfig = LazyMount.mount( entityManager,
                        "mgmt/security/sh-sec-prof/config",
                        "Mgmt::Security::SharedSecretProfile::Config", "r" )
   filteredRibStatus = SharkLazyMount.mount(
         entityManager,
         "routing/filteredRibStatus",
         "Routing::Rib::FilteredRibStatus",
         SharkLazyMount.mountInfo( "shadow" ),
         True )

   IntfCli.Intf.registerDependentClass( IsisIntf, priority=20 )
   IraVrfCli.canDeleteVrfHook.addExtension( deleteVrfHook )
   CliPlugin.SegmentRoutingCli.validateNodeSegmentHook.addExtension(
         checkNodeSegmentConflict )
