#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin.SnmpCli import snmpServerKwMatcher

matcherRoutingMibs = CliMatcher.KeywordMatcher( 'routing-mibs',
      helpdesc='Enable routing-related MIBS' )

#--------------------------------------------------------------------------------
# [ no | default ] snmp-server routing-mibs
#--------------------------------------------------------------------------------
class SnmpServerRoutingMibsCmd( CliCommand.CliCommandClass ):
   syntax = 'snmp-server routing-mibs'
   noOrDefaultSyntax = syntax
   data = {
      'snmp-server': snmpServerKwMatcher,
      'routing-mibs': matcherRoutingMibs,
   }
   hidden = True
   handler = "RoutingSnmpGlobalConfigModeHandler.handlerSnmpServerRoutingMibsCmd"
   noHandler = "RoutingSnmpGlobalConfigModeHandler.noHandlerSnmpServerRoutingMibsCmd"
   defaultHandler = \
      "RoutingSnmpGlobalConfigModeHandler.defaultHandlerSnmpServerRoutingMibsCmd"

BasicCliModes.GlobalConfigMode.addCommandClass( SnmpServerRoutingMibsCmd )

#--------------------------------------------------------------------------------
# snmp-server routing-mibs timers PING RESTART
#--------------------------------------------------------------------------------
class SnmpServerRoutingMibsTimersPingRestartCmd( CliCommand.CliCommandClass ):
   _minTime = 2
   _maxTime = 600
   syntax = 'snmp-server routing-mibs timers PING RESTART'
   noOrDefaultSyntax = 'snmp-server routing-mibs timers ...'
   data = {
      'snmp-server': snmpServerKwMatcher,
      'routing-mibs': matcherRoutingMibs,
      'timers': 'Agentx Timers',
      'PING': CliMatcher.IntegerMatcher( _minTime, _maxTime,
                                         helpdesc='Ping interval' ),
      'RESTART': CliMatcher.IntegerMatcher( _minTime, _maxTime,
                                            helpdesc='Restart interval' ),
   }
   hidden = True
   handler = \
      "RoutingSnmpGlobalConfigModeHandler." + \
      "handlerSnmpServerRoutingMibsTimersPingRestartCmd"
   noOrDefaultHandler = \
      "RoutingSnmpGlobalConfigModeHandler." + \
      "noOrDefaultHandlerSnmpServerRoutingMibsTimersPingRestartCmd"

BasicCliModes.GlobalConfigMode.addCommandClass(
      SnmpServerRoutingMibsTimersPingRestartCmd )
