#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
import CliSave
import LazyMount
import Tracing

t0 = Tracing.trace0

gv = CliGlobal.CliGlobal( sysInitStatus=None )

def systemInitialized():
   # Enable running-config cache only when system is initialized.
   # This is because some CliSave plugins might output different things based on
   # hw capabilities, which should have been set when system is initialiazed.
   #
   # This also means we won't have cache enabled in most of the tests run in a
   # workspacesince the flag isn't set, but we do set it in namespace duts.
   return gv.sysInitStatus.initialized

def Plugin( em ):
   gv.sysInitStatus = LazyMount.mount( em, "sys/status/system", "System::Status",
                                       "r" )
   CliSave.runningConfigCacheEnabledHook.addExtension( systemInitialized )
