# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliGlobal
import CliMatcher
import CliPlugin
from CliToken.Hardware import hardwareMatcherForShow
from CliToken.System import systemMatcherForHardwareSystem
import LazyMount
import ShowCommand
from Toggles import ScdToggleLib

cliGlobal = CliGlobal.CliGlobal( entityMib=None, spiFlashDir=None )

#--------------------------------------------------------------------------------
# show hardware system spi-chips
#--------------------------------------------------------------------------------
matcherSpiChips = CliMatcher.KeywordMatcher(
   'spi-chips',
   helpdesc='SPI flash chip information' )

class SpiChipsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware system spi-chips'
   data = {
      'hardware': hardwareMatcherForShow,
      'system': systemMatcherForHardwareSystem,
      'spi-chips': CliCommand.Node( matcher=matcherSpiChips )
   }
   handler = 'ScdCliHandler.showHardwareSystemSpiChipsHandler'
   cliModel = 'ScdCliModel.SpiChips'

if ScdToggleLib.toggleScdFlashEnabled():
   BasicCli.addShowCommandClass( SpiChipsCmd )

#--------------------------------------------------------------------------------
# show platform scd satellite debug
#--------------------------------------------------------------------------------
matcherPlatform = CliMatcher.KeywordMatcher(
   'platform',
   helpdesc='Platform-specific information' )
matcherScd = CliMatcher.KeywordMatcher(
   'scd',
   helpdesc='System control device information' )
matcherSatellite = CliMatcher.KeywordMatcher(
   'satellite',
   helpdesc='SCD satellite information' )
matcherScdName = CliMatcher.DynamicNameMatcher(
   CliPlugin.Scd.satelliteScdNameFn,
   'Scd name' )
matcherDebug = CliMatcher.KeywordMatcher(
   'debug',
   helpdesc='debug information' )

class SatelliteErrorsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform scd satellite [ SCD-NAME ] debug'
   data = {
      'platform': matcherPlatform,
      'scd': CliCommand.Node( matcher=matcherScd,
                              guard=CliPlugin.Scd.satelliteScdGuard ),
      'satellite': matcherSatellite,
      'SCD-NAME': matcherScdName,
      'debug': matcherDebug,
   }
   handler = CliPlugin.Scd.doShowSatelliteDebug
   cliModel = CliPlugin.Scd.SatelliteDebug
   privileged = True

BasicCli.addShowCommandClass( SatelliteErrorsCmd )

#--------------------------------------------------------------------------------
# Plugin
#--------------------------------------------------------------------------------
def Plugin( entityManager ):
   cliGlobal.entityMib = LazyMount.mount( entityManager, 'hardware/entmib',
                                          'EntityMib::Status', 'r' )
   cliGlobal.spiFlashDir = LazyMount.mount( entityManager, 'hardware/spi/flash',
                                            'Tac::Dir', 'ri' )
