#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
import AgentDirectory
import BasicCli
import CliCommand
import CliMatcher
import CliParser
import ShowCommand
import Tac
from CliToken.Platform import platformMatcherForShow

# Check if we are running on Strata or Sand
def schanAccelEnabledGuard( mode, token ):
   if AgentDirectory.agent( mode.sysname, 'Sand' ) or \
      AgentDirectory.agent( mode.sysname, 'StrataCentral' ):
      return None
   return CliParser.guardNotThisPlatform

#--------------------------------------------------------------------------------
# show platform schanaccel
#--------------------------------------------------------------------------------
class ShowPlatformSchanAccelCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform schanaccel'
   data = {
      'platform': platformMatcherForShow,
      'schanaccel': CliCommand.Node(
                        matcher=CliMatcher.KeywordMatcher(
                              'schanaccel',
                              helpdesc='S-Channel accelerator info' ),
                        guard=schanAccelEnabledGuard ),
   }
   privileged = True

   @staticmethod
   def handler( mode, args ):
      try:
         # Run as root to allow dmamem to mmap /dev/mem
         Tac.run( [ '/usr/bin/schanaccel', 'dump' ],
                  stdout=sys.stdout, stderr=sys.stderr, asRoot=True )
      except Tac.SystemCommandError as e:
         # pylint: disable-next=consider-using-f-string
         mode.addError( 'Unexpected error: %s' % e )


BasicCli.addShowCommandClass( ShowPlatformSchanAccelCmd )
