#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-msg=protected-access

from CliModel import (
   Dict,
   Int,
   DeferredModel,
   Model,
   Submodel,
)

class ApplicationDataModel( Model ):
   totalFlows = Int( help="Number of flows received for an application service" )
   totalPackets = Int( help="Number of packets received for an application service" )
   totalBytes = Int( help="Number of bytes received for an application service" )
   classifierPackets = Int( help="Number of packets processed by the classifier" )

class VrfApplicationCountersModel( Model ):
   vrfId = Int( help="VRF identifier" )
   categories = Dict( keyType=str, valueType=int,
                      help="A mapping of category names to ids" )
   profiles = Dict( keyType=str, valueType=int,
                    help="A mapping of profile names to ids" )

   counters = Submodel( valueType=ApplicationDataModel,
                        help="Counters for an application service" )

class ServiceVrfsModel( Model ):
   serviceId = Int( help="Service identifier" )
   vrfs = Dict( keyType=str,
           valueType=VrfApplicationCountersModel,
           help="Application service data keyed by VRF name" )

class ApplicationCountersModel( Model ):
   appId = Int( help="Application identifier" )
   services = \
      Dict( keyType=str, valueType=ServiceVrfsModel,
           help="Services available for the application, keyed by service name" )

# Based on ShowApplications but uses an external render function.
class ShowApplicationCounters( DeferredModel ):
   applications = \
     Dict( keyType=str, valueType=ApplicationCountersModel,
           help="Applications configured on the switch, keyed by application name" )
