#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliToken.AvtCliToken import (
   avtNodeForShow,
   AvtVrfExprFactory,
   AvtNameExprFactory,
)
from CliToken.Flow import (
   flowMatcherForShow,
)
from CliToken.SfeFlowCliToken import (
   nodeSrcIp,
   nodeIPv4,
   nodeDstIp,
   nodeSrcPort,
   nodePort,
   nodeDstPort,
   nodeProtocol,
   nodeProtocolValue
)

import BasicCli
import CliGlobal
import LazyMount
import ShowCommand
import Tac

gv = CliGlobal.CliGlobal( dict( avtCliConfig=None ) )

avtFilterHelpStr = 'Filter by adaptive virtual topology name'
vrfFilterHelpStr = 'Filter by VRF name'

# -----------------------------------------------------------------------------------
# show adaptive-virtual-topology flows [ vrf VRF [ avt AVT ] ] [ src-ip SRC_IP ]
#    [ src-port SRC_PORT ] [ dst-ip DST_IP ] [ dst-port DST_PORT ] [ protocol PROTO ]
# -----------------------------------------------------------------------------------
class ShowAvtFlows( ShowCommand.ShowCliCommandClass ):
   syntax = '''show adaptive-virtual-topology flow [ VRF [ AVT ] ]
               [ { ( src-ip SRC_IP ) |
                   ( dst-ip DST_IP ) |
                   ( src-port SRC_PORT ) |
                   ( dst-port DST_PORT ) |
                   ( protocol PROTOCOL ) } ] '''
   data = {
      'adaptive-virtual-topology' : avtNodeForShow,
      'flow' : flowMatcherForShow,
      'VRF' : AvtVrfExprFactory( vrfFilterHelpStr ),
      'AVT' : AvtNameExprFactory( avtFilterHelpStr ),
      'src-ip' : nodeSrcIp,
      'SRC_IP' : nodeIPv4,
      'dst-ip' : nodeDstIp,
      'DST_IP' : nodeIPv4,
      'src-port' : nodeSrcPort,
      'SRC_PORT' : nodePort,
      'dst-port' : nodeDstPort,
      'DST_PORT' : nodePort,
      'protocol' : nodeProtocol,
      'PROTOCOL' : nodeProtocolValue
   }
   cliModel = "SfeAvtShowFlowModel.AvtFlowsModel"
   handler = "SfeAvtShowCliHandler.ShowAvtFlowsHandler"

BasicCli.addShowCommandClass( ShowAvtFlows )

def Plugin( entityManager ):
   gv.avtCliConfig = LazyMount.mount( entityManager, 'avt/input/cli',
                                      'Avt::AvtCliConfig', 'r' )
