# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
import LazyMount

gv = CliGlobal.CliGlobal( dict( entityManager=None, veosConfig=None,
                                naciesStatus=None ) )

def getNaciesPortIntfMap():
   if gv.veosConfig and gv.veosConfig.platformCaravan and gv.naciesStatus:
      return gv.naciesStatus.portIntfMap
   return None

def Plugin( em ):
   gv.entityManager = em
   gv.veosConfig = LazyMount.mount( em, "hardware/sfe/veosConfig",
                                    "Sfe::VeosConfig", "r" )
   gv.naciesStatus = LazyMount.mount( em, "nacies/status",
                                      "NacIes::Status", "r" )
