# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac
from BasicCli import addShowCommandClass
from CliModel import cliPrinted
from ShowCommand import ShowCliCommandClass
from AgentCommandRequest import runCliPrintSocketCommand
from CliCommand import (
   CliExpression,
   singleKeyword,
)
from CliToken.Platform import platformMatcherForShow
from CliPlugin import SfeWorkerShowModel
from CliPlugin.SfeCliLib import nodeSfe

allFlowTypesKw = singleKeyword( "all",
      helpdesc="Display all flow types assigned to a specific worker" )
ipsecFlowsKw = singleKeyword( "ipsec",
      helpdesc="Display IPSec flows processed by a specific worker" )
dpiFlowsKw = singleKeyword( "dpi",
      helpdesc="Display DPI flows processed by a specific worker" )
workerKw = singleKeyword( "worker",
      helpdesc="Worker Information" )
summaryKw = singleKeyword( "summary",
      helpdesc="Summary" )

class ShowWorkerSummaryFilterExp( CliExpression ):
   expression = ''' all | ipsec | dpi '''
   data = {
      'all' : allFlowTypesKw,
      'ipsec' : ipsecFlowsKw,
      'dpi' : dpiFlowsKw
   }

class ShowWorkerSummaryCmd( ShowCliCommandClass ):
   syntax = ( '''show platform sfe worker summary [ FILTER ]''' )
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'worker' : workerKw,
      'summary' : summaryKw,
      'FILTER' : ShowWorkerSummaryFilterExp
   }
   cliModel = SfeWorkerShowModel.ShowWorkerSummary

   @staticmethod
   def handler( mode, args ):
      params = ' '.join( f'{kw}=1'
                     for kw in ShowWorkerSummaryFilterExp.data
                     if kw in args )
      model = SfeWorkerShowModel.ShowWorkerSummary
      model = runCliPrintSocketCommand( mode.entityManager,
                                        'Sfe',
                                        'worker-info',
                                        params,
                                        mode,
                                        keepalive=True,
                                        connErrMsg="Sfe agent is inactive",
                                        model=model )
      return cliPrinted( model ) if model else None

addShowCommandClass( ShowWorkerSummaryCmd )
