# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import (
   Int,
   Model,
   Dict
)

class WorkerInfoModel( Model ):
   busy = Int( help="Worker busy percentage" )
   pps = Int( help="Worker packets per second" )
   ipsec = Int( optional=True, help="IPsec flows" )
   ipsecPps = Int( optional=True, help="IPsec packets per second" )
   dpi = Int( optional=True, help="DPI flows" )
   dpiPkts = Int( optional=True, help="DPI packets" )

class ShowWorkerSummary( Model ):
   workers = Dict( keyType=int, valueType=WorkerInfoModel,
         help="Worker Summary, keyed by worker ID" )
