#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import ConfigMount
from CliPlugin.BridgingEtbaCli import PlatformTfaConfigMode, tfaConfigModeCleanupHook
from CliPlugin.FlowTrackingCli import matchHardware, matchOffload
from CliPlugin.FlowTrackingCliLib import (
   guardSampledHwOffload,
   sampledConfigKw,
   trackingConfigKw
)
from CliToken.Flow import flowMatcherForConfig

etbaCliConfig = None

# -----------------------------------------------------------------------------------
# "platform-tfa#flow tracking sampled hardware offload lag member" command
# -----------------------------------------------------------------------------------
class EtbaPoMemberSamplingCmd( CliCommand.CliCommandClass ):
   syntax = 'flow tracking sampled hardware offload lag member'
   noOrDefaultSyntax = syntax
   data = {
      'flow' : flowMatcherForConfig,
      'tracking' : trackingConfigKw,
      'sampled' : sampledConfigKw,
      'hardware' : CliCommand.Node( matchHardware, guard=guardSampledHwOffload ),
      'offload' : matchOffload,
      'lag' : "Port-channel",
      'member' : 'Port-channel member',
   }

   @staticmethod
   def handler( mode, args ):
      etbaCliConfig.poMemberIntfHwOffload = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      etbaCliConfig.poMemberIntfHwOffload = False

PlatformTfaConfigMode.addCommandClass( EtbaPoMemberSamplingCmd )

def tfaConfigModeCleanup( mode ):
   EtbaPoMemberSamplingCmd.noOrDefaultHandler( mode, {} )

def Plugin( entityManager ):
   global etbaCliConfig
   etbaCliConfig = ConfigMount.mount( entityManager, "bridging/etba/cli/config",
                                      "Bridging::Etba::CliConfig", "w" )
   tfaConfigModeCleanupHook.addExtension( tfaConfigModeCleanup )
