# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliToken.Debugging import debuggingMatcherForShow
import ShowCommand

# --------------------------------------------------------------------------------
# show debugging shark clients all
# --------------------------------------------------------------------------------
class SharkClientsAllCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging shark clients all'
   data = {
      'debugging': debuggingMatcherForShow,
      'shark': 'Show information about Shark tables',
      'clients': 'Show the clients of Shark tables',
      'all': 'Show information for all Shark tables',
   }
   cliModel = "SharkModel.WhoAll"
   handler = "SharkCliHandler.sharkClientsAllHandler"
   privileged = True

BasicCli.addShowCommandClass( SharkClientsAllCmd )
