#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import ShowCommand
from CliPlugin.ShowConfigConsistencyCliModels import ConfigConsistencyMultiTableModel
from ConfigConsistencyChecker import ConfigConsistencyChecker

# --------------------------------------------------------------------------------
# show configuration consistency igmp snooping
# --------------------------------------------------------------------------------
def showConfigurationConsistencyIgmpSnooping( mode, args ):
   ClusterChecker = ConfigConsistencyChecker.getClusterChecker( 'snooping' )
   return ClusterChecker.check( [ 'vlan' ], mode, args )

class ShowConfigConsistencyIgmpSnoopingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = "show configuration consistency igmp snooping"
   data = {
      "configuration": "Show configuration information",
      "consistency": "Verify configuration consistency",
      "igmp": "Show hints of potential problems related to IGMP",
      "snooping": ConfigConsistencyChecker.getClusterChecker(
         'snooping' ).clusterMatcher(),
   }

   handler = showConfigurationConsistencyIgmpSnooping
   cliModel = ConfigConsistencyMultiTableModel

BasicCli.addShowCommandClass( ShowConfigConsistencyIgmpSnoopingCmd )
