#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliPlugin.SnmpCli as SnmpCli # pylint: disable=consider-using-from-import
from CliMatcher import StringMatcher
from CliToken.Test import testMatcherForExec

#--------------------------------------------------------------------------------
# test snmp notification [ COMMENT ]
#--------------------------------------------------------------------------------
class TestSnmpNotificationCmd( CliCommand.CliCommandClass ):
   syntax = 'test snmp notification [ COMMENT ]'
   data = {
      'test': testMatcherForExec,
      'snmp': 'Send a test SNMP notification',
      'notification': 'Send a test SNMP notification',
      'COMMENT': StringMatcher(
         helpdesc='optional string to be sent along with the notification',
         helpname='COMMENT' ),
   }
   handler = SnmpCli.sendTestNotification

BasicCliModes.EnableMode.addCommandClass( TestSnmpNotificationCmd )
