#!/usr/bin/env python3
# Copyright (c) 2010, 2011, 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
from CliPlugin import Ip6AddrMatcher
from CliPlugin import IpAddrMatcher
import CliToken.Ip
import SharedMem
import ShowCommand

smashMount = None

mcastKwMatcher = CliMatcher.KeywordMatcher( 'multicast',
      helpdesc='Show multicast Reverse Path Forwarding information' )
vrfNameExpr = VrfCli.VrfExprFactory(
      helpdesc='VRF name' )

#--------------------------------------------------------------------------------
# show ip route [ vrf VRF_NAME ] multicast [ PREFIX ]
#--------------------------------------------------------------------------------
class ShowIpv4RouteMulticast( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip route [ VRF ] multicast [ PREFIX ]'
   data = {
      'ip' : CliToken.Ip.ipMatcherForShow,
      'route': 'Entries used for routing packets',
      'VRF': vrfNameExpr,
      'multicast': mcastKwMatcher,
      'PREFIX': IpAddrMatcher.ipPrefixExpr( 'Source prefix',
                                            'Source prefix mask',
                                            'Source address with prefix',
                                            partial=True )
   }
   cliModel = "McastCommonModel.MulticastRibRoutes"
   handler = "StaticMribShowCliHandler.handlerShowIpv4RouteMulticast"

BasicCli.addShowCommandClass( ShowIpv4RouteMulticast )

#--------------------------------------------------------------------------------
# show ipv6 route [ vrf VRF_NAME ] multicast [ PREFIX ]
#--------------------------------------------------------------------------------
class ShowIpv6RouteMulticast( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ipv6 route [ VRF ] multicast [ PREFIX ]'

   data = {
         'ipv6': CliToken.Ipv6.ipv6MatcherForShow,
         'route': 'IPv6 routing table',
         'VRF': vrfNameExpr,
         'multicast': mcastKwMatcher,
         'PREFIX': Ip6AddrMatcher.Ip6PrefixValidMatcher(
            overlap=IpAddrMatcher.PREFIX_OVERLAP_AUTOZERO,
            helpdesc='IPv6 address prefix' ),
   }

   cliModel = "McastCommonModel.MulticastRib6Routes"
   handler = "StaticMribShowCliHandler.handlerShowIpv6RouteMulticast"

BasicCli.addShowCommandClass( ShowIpv6RouteMulticast )

def Plugin( entityManager ):
   global smashMount

   smashMount = SharedMem.entityManager( sysdbEm=entityManager )
