#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=ungrouped-imports

import CliCommand
import CliMatcher
import BasicCliModes
import CliPlugin.StpClearLib as StpClear
import CliPlugin.IntfCli as IntfCli # pylint: disable=consider-using-from-import
from CliToken.Clear import clearKwNode

matcherCounters = CliMatcher.KeywordMatcher( 'counters',
      helpdesc='Clear spanning tree BPDU counters in all sessions' )
matcherInterface = CliMatcher.KeywordMatcher( 'interface',
      helpdesc='Specify an interface as a target for the command' )
matcherSpanningTree = CliMatcher.KeywordMatcher( 'spanning-tree',
      helpdesc='Clear spanning tree parameters' )

#--------------------------------------------------------------------------------
# clear spanning-tree counters [ interface INTERFACE ]
#--------------------------------------------------------------------------------
class ClearSpanningTreeCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear spanning-tree counters [ interface INTERFACE ]' 
   data = {
      'clear': clearKwNode,
      'spanning-tree': matcherSpanningTree,
      'counters': matcherCounters,
      'interface': matcherInterface,
      'INTERFACE': IntfCli.Intf.matcherWOSubIntf
   }
   handler = StpClear.clearCounters

BasicCliModes.EnableMode.addCommandClass( ClearSpanningTreeCountersCmd )

#--------------------------------------------------------------------------------
# clear spanning-tree counters session
#--------------------------------------------------------------------------------
class ClearSpanningTreeCountersSessionCmd( CliCommand.CliCommandClass ):
   syntax = 'clear spanning-tree counters session'
   data = {
      'clear': clearKwNode,
      'spanning-tree': matcherSpanningTree,
      'counters': matcherCounters,
      'session': 'Clear spanning tree BPDU counters in current session',
   }
   handler = StpClear.clearCountersSession

BasicCliModes.EnableMode.addCommandClass( ClearSpanningTreeCountersSessionCmd )

#--------------------------------------------------------------------------------
# clear spanning-tree detected-protocols [ interface INTERFACE ]
#--------------------------------------------------------------------------------
class ClearSpanningTreeDetectedProtocolsCmd( CliCommand.CliCommandClass ):
   syntax = 'clear spanning-tree detected-protocols [ interface INTERFACE ]'
   data = {
      'clear': clearKwNode,
      'spanning-tree': matcherSpanningTree,
      'detected-protocols': 'Restart the protocol migration process',
      'interface': matcherInterface,
      'INTERFACE': IntfCli.Intf.matcherWOSubIntf
   }
   handler = StpClear.clearProtocols

BasicCliModes.EnableMode.addCommandClass( ClearSpanningTreeDetectedProtocolsCmd )
