#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=ungrouped-imports

import BasicCli
import CliCommand
import CliMatcher
import ShowCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.StpShowLib as StpShowLib
import CliPlugin.VlanCli as VlanCli # pylint: disable=consider-using-from-import
import CliPlugin.StpCliLib as StpCliLib # pylint: disable=consider-using-from-import
from CliPlugin.StpModels import ( 
      SpanningTreeInstances,
      SpanningTreeInterfaces,
      SpanningTreeVlanInstances,
      SpanningTreeBridgeAssurance,
      SpanningTreeRoots,
      SpanningTreeBridgeMstTestInfoModel,
      SpanningTreeBlockedPorts,
      SpanningTreeMstInterfaces,
      SpanningTreeMstInstances,
      SpanningTreeBridges,
      SpanningTreeMstConfiguration,
      SpanningTreeCounters
)

matcherBridge = CliMatcher.KeywordMatcher( 'bridge',
      helpdesc='Status and configuration of this bridge' )
matcherDetail = CliMatcher.KeywordMatcher( 'detail', 
      helpdesc='Display information in detail' )
matcherInterface = CliMatcher.KeywordMatcher( 'interface',
      helpdesc='Spanning Tree interface status and configuration' )
matcherMst = CliMatcher.KeywordMatcher( 'mst', helpdesc='Multiple spanning trees' )
matcherSpanningTree = CliMatcher.KeywordMatcher( 'spanning-tree',
      helpdesc='Details on STP' )

#--------------------------------------------------------------------------------
# show spanning-tree blockedports
#--------------------------------------------------------------------------------
class SpanningTreeBlockedportsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree blockedports'
   data = {
      'spanning-tree': matcherSpanningTree,
      'blockedports': 'Show blocked ports',
   }
   handler = StpShowLib.showStpBlocked
   cliModel = SpanningTreeBlockedPorts

BasicCli.addShowCommandClass( SpanningTreeBlockedportsCmd )

#--------------------------------------------------------------------------------
# show spanning-tree bridge assurance [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeBridgeAssuranceCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree bridge assurance [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'bridge': CliCommand.
                Node( matcher=matcherBridge, 
                      deprecatedByCmd='show spanning-tree instance/transmit' ),
      'assurance': 'Show bridge assurance state of ports',
      'detail': matcherDetail,
   }
   handler = StpShowLib.showBridgeAssurance
   cliModel = SpanningTreeBridgeAssurance

BasicCli.addShowCommandClass( SpanningTreeBridgeAssuranceCmd )

#--------------------------------------------------------------------------------
# show spanning-tree bridge [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeBridgeCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree bridge [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'bridge': CliCommand.
                Node( matcher=matcherBridge,
                      deprecatedByCmd='show spanning-tree instance/transmit' ),
      'detail': matcherDetail,
   }
   handler = StpShowLib.showBridge
   cliModel = SpanningTreeBridges

BasicCli.addShowCommandClass( SpanningTreeBridgeCmd )

#--------------------------------------------------------------------------------
# show spanning-tree [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'detail': matcherDetail,
   }
   handler = StpShowLib.showStp
   cliModel = SpanningTreeInstances

BasicCli.addShowCommandClass( SpanningTreeCmd )

#--------------------------------------------------------------------------------
# show spanning-tree counters
#--------------------------------------------------------------------------------
class SpanningTreeCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree counters'
   data = {
      'spanning-tree': matcherSpanningTree,
      'counters': 'Show port BPDU counters',
   }
   handler = StpShowLib.showCounters
   cliModel = SpanningTreeCounters

BasicCli.addShowCommandClass( SpanningTreeCountersCmd )

#--------------------------------------------------------------------------------
# show spanning-tree instance [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeInstanceCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree instance [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'instance': 'Status and configuration of this bridge',
      'detail': matcherDetail,
   }
   handler = StpShowLib.showBridge
   cliModel = SpanningTreeBridges

BasicCli.addShowCommandClass( SpanningTreeInstanceCmd )

#--------------------------------------------------------------------------------
# show spanning-tree interface ETHINTF [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeInterfaceEthintfCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree interface ETHINTF [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'interface': matcherInterface,
      'ETHINTF': StpCliLib.stpIntfMatcher,
      'detail': matcherDetail,
   }
   handler = StpShowLib.showInterface
   cliModel = SpanningTreeInterfaces

BasicCli.addShowCommandClass( SpanningTreeInterfaceEthintfCmd )

#--------------------------------------------------------------------------------
# show spanning-tree mst [ MST ] [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeMstCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree mst [ MST ] [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'mst': matcherMst,
      'MST': CliMatcher.IntegerMatcher( 0, 4094, helpdesc='MST instance ID' ),
      'detail': matcherDetail,
   }
   handler = StpShowLib.showMst
   cliModel = SpanningTreeMstInstances

BasicCli.addShowCommandClass( SpanningTreeMstCmd )

#--------------------------------------------------------------------------------
# show spanning-tree mst configuration [ digest ]
#--------------------------------------------------------------------------------
class SpanningTreeMstConfigurationCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree mst configuration [ digest ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'mst': matcherMst,
      'configuration': 'MST current region configuration',
      'digest': 'Display MST configuration digest',
   }
   handler = StpShowLib.showMstConfiguration
   cliModel = SpanningTreeMstConfiguration

BasicCli.addShowCommandClass( SpanningTreeMstConfigurationCmd )

#--------------------------------------------------------------------------------
# show spanning-tree mst [ MST ] interface ETHINTF [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeMstInterfaceEthintfCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree mst [ MST ] interface ETHINTF [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'mst': matcherMst,
      'MST': CliMatcher.IntegerMatcher( 0, 4094, helpdesc='MST instance ID' ),
      'interface': matcherInterface,
      'ETHINTF': StpCliLib.stpIntfMatcher,
      'detail': matcherDetail,
   }
   handler = StpShowLib.showMstInterface
   cliModel = SpanningTreeMstInterfaces

BasicCli.addShowCommandClass( SpanningTreeMstInterfaceEthintfCmd )

#--------------------------------------------------------------------------------
# show spanning-tree mst test information
#--------------------------------------------------------------------------------
class SpanningTreeMstTestInformationCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree mst test information'
   data = {
      'spanning-tree': matcherSpanningTree,
      'mst': matcherMst,
      'test': 'Test friendly information',
      'information': 'Test friendly information',
   }
   handler = StpShowLib.showMstTestInfo
   cliModel = SpanningTreeBridgeMstTestInfoModel

BasicCli.addShowCommandClass( SpanningTreeMstTestInformationCmd )

#--------------------------------------------------------------------------------
# show spanning-tree root [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeRootCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree root [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'root': 'Status and configuration of the root bridge',
      'detail': matcherDetail,
   }
   handler = StpShowLib.showRoot
   cliModel = SpanningTreeRoots

BasicCli.addShowCommandClass( SpanningTreeRootCmd )

#--------------------------------------------------------------------------------
# show spanning-tree transmit active [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeTransmitActiveCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree transmit active [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'transmit': 'Show BPDU transmit parameters',
      'active': 'Show bridge assurance state of ports',
      'detail': matcherDetail,
   }
   handler = StpShowLib.showBridgeAssurance
   cliModel = SpanningTreeBridgeAssurance

BasicCli.addShowCommandClass( SpanningTreeTransmitActiveCmd )

#--------------------------------------------------------------------------------
# show spanning-tree vlan [ VLANSET ] [ detail ]
#--------------------------------------------------------------------------------
class SpanningTreeVlanCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show spanning-tree vlan [ VLANSET ] [ detail ]'
   data = {
      'spanning-tree': matcherSpanningTree,
      'vlan': 'Report on a VLAN',
      'VLANSET': VlanCli.vlanSetMatcher,
      'detail': matcherDetail,
   }
   handler = StpShowLib.showSpanVlan
   cliModel = SpanningTreeVlanInstances

BasicCli.addShowCommandClass( SpanningTreeVlanCmd )
