# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-in

import sys
import Tac, Tracing, Cell, LazyMount # pylint: disable=ungrouped-imports
import BasicCliUtil
from Fru import slotId
import FileReplicationCmds
from issh import issh
from CliPlugin.RedSupModels import PeerSupeCliCmdModel

__defaultTraceHandle__ = Tracing.Handle( "SupeSessionCli" )
t0 = Tracing.trace0

electionStatus = None

#--------------------------------------------------------------
# session peer-supervisor 
#--------------------------------------------------------------
@BasicCliUtil.EapiIncompatible()
def runCliOnPeerSupe( mode, args ):
   argv = handleBasePeerSupeCmd( mode )
   if not argv:
      return

   try:
      Tac.run( argv, stdin=sys.stdin, stdout=sys.stdout )
      # To print the prompt in the next line when user hits ^D on the peer sup CLI
      print( "" )
   except Tac.SystemCommandError:
      mode.addError( "Peer connection failed" )

#--------------------------------------------------------------
# session peer-supervisor CMD
#--------------------------------------------------------------
# pylint: disable-next=inconsistent-return-statements
def runCliCmdOnPeerSupe( mode, args ):
   argv = handleBasePeerSupeCmd( mode )
   res = PeerSupeCliCmdModel()
   if not argv:
      return res
   argv += args[ 'CMD' ].split()
   try:
      cliCmdOutput = Tac.run( argv, stdout=Tac.CAPTURE )
      res.output = cliCmdOutput
      return res
   except Tac.SystemCommandError as e:
      mode.addError( e.output.rstrip() )

def handleBasePeerSupeCmd( mode ):
   if electionStatus.redundancyMode != 'active':
      mode.addError( "Command is unavailable on this supervisor" )
      return None

   if electionStatus.peerState == 'notInserted' or \
         electionStatus.peerState == 'powerdOff':
      mode.addError( "Peer supervisor is unavailable" )
      return None

   argv = [ issh(),
            '-l', 'sessionuser', '-q',
            FileReplicationCmds.peerAddress[ slotId() ] ]
   return argv

def Plugin( entityManager ):
   global electionStatus
   electionStatus = LazyMount.mount( entityManager,
                                     Cell.path( 'redundancy/election/status' ),
                                    'Election::Status', 'r' )
