#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""CLI commands for configuring SWAG"""

import BasicCli
import CliCommand
import CliMatcher
import CliToken.Switch
from CliPlugin.FabricChannelIntfCli import FabricChannelIntfConfigModelet
from CliPlugin.SwagCliLib import (
   swagSupported,
   memberIdTokenMatcher,
   memberIdValueMatcher,
)
from Toggles.SwagCoreToggleLib import toggleSwagPhase1Enabled

#-----------------------------------------------------------
# (config)# switch aggregation
#-----------------------------------------------------------
matcherAggregation = CliCommand.guardedKeyword(
   'aggregation',
   helpdesc='Configure switch aggregation parameters',
   guard=swagSupported )

class SwagCommand( CliCommand.CliCommandClass ):
   syntax = 'switch aggregation'
   noOrDefaultSyntax = syntax

   data = {
      'switch': CliToken.Switch.matcherSwitchForConfig,
      'aggregation': matcherAggregation,
   }

   handler = 'SwagConfigCliHandler.swagCommandHandler'
   noOrDefaultHandler = 'SwagConfigCliHandler.swagCommandDefaultHandler'

if toggleSwagPhase1Enabled():
   BasicCli.GlobalConfigMode.addCommandClass( SwagCommand )

peerMemberMatcher = CliMatcher.KeywordMatcher(
   'member', helpdesc="Configure switch aggregation member" )
# -------------------------------------------------------------------------------
# (config-if-Fc<MEMBER_ID/CHANNEL_ID>)# peer member id <PEER_ID>
# -------------------------------------------------------------------------------

class FcIntfPeerId( CliCommand.CliCommandClass ):
   syntax = 'peer member id PEER_ID'
   noOrDefaultSyntax = 'peer member id...'
   data = {
      'peer': 'Configure switch aggregation peer',
      'member': peerMemberMatcher,
      'id': memberIdTokenMatcher,
      'PEER_ID': memberIdValueMatcher,
   }
   handler = 'SwagConfigCliHandler.fcIntfCommandHandler'
   noOrDefaultHandler = handler

if toggleSwagPhase1Enabled():
   FabricChannelIntfConfigModelet.addCommandClass( FcIntfPeerId )
