#!/usr/bin/env arista-python
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import (
   absolute_import,
   division,
   print_function,
)

from CliPlugin.SynceConfigCli import synceSupported
import CliPlugin.TechSupportCli

#-------------------------------------------------------------------------------
# Synce show commands in 'show tech-support'
#-------------------------------------------------------------------------------

CliPlugin.TechSupportCli.registerShowTechSupportCmd( '2021-12-08 19:55:48',
                                                     cmds=[
                                                        'show sync-e',
                                                        'show sync-e selection',
                                                        'show sync-e esmc counters',
                                                        'show sync-e esmc detail',
                                                     ],
                                                     cmdsGuard=synceSupported )
cmds = [
   'show agent Synce debug',
]
CliPlugin.TechSupportCli.registerShowTechSupportCmd( '2022-01-06 08:26:57',
                                                     cmds,
                                                     cmdsGuard=synceSupported,
                                                     extended='sync-e' )
