# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import CliPlugin.VlanCli as VlanCli # pylint: disable=consider-using-from-import
# pylint: disable-next=consider-using-from-import
import CliPlugin.TapAggIntfCli as TapAggIntfCli
from CliPlugin.MirroringTapAggConfigMode import matcherDzGreSwitch

matcherId = CliMatcher.KeywordMatcher( 'id',
   helpdesc='Configure ID' )
matcherVlan = CliMatcher.KeywordMatcher( 'vlan',
   helpdesc='Configure VLAN parameters' )

#--------------------------------------------------------------------------------
# switch id ( ( SWITCH_ID port PID PORT_ID ) |
#             ( unmatched port PID unmmatched_token ) ) vlan VLAN_ID
# [ no | default ] switch id ( ( SWITCH_ID port PID PORT_ID ) |
#                              ( unmatched port PID unmatched_token ) )...
#--------------------------------------------------------------------------------
class SwitchPortToVlanMapCmd( CliCommand.CliCommandClass ):
   syntax = '''switch id
               ( ( SWITCH_ID port PID PORT_ID )
               | ( unmatched port PID unmatched_token ) )
               vlan VLAN_ID'''
   noOrDefaultSyntax = syntax.replace( 'vlan VLAN_ID', '...' )
   data = {
      'switch': matcherDzGreSwitch,
      'id' : matcherId,
      'unmatched': 'Unmatched switch identity',
      'SWITCH_ID' : CliMatcher.IntegerMatcher( 1, 4095,
         helpdesc='Switch identity' ),
      'port' : 'Configure port ID',
      'PID' : matcherId,
      'unmatched_token': CliMatcher.KeywordMatcher( 'unmatched',
         helpdesc='Unmatched port identity' ),
      'PORT_ID' : CliMatcher.IntegerMatcher( 1, 65535,
         helpdesc='Port identity' ),
      'vlan' : matcherVlan,
      'VLAN_ID' : VlanCli.vlanIdMatcher,
   }
   handler = TapAggIntfCli.setDzGreSwitchPortToVlan
   noOrDefaultHandler = TapAggIntfCli.noDzGreSwitchPortToVlan

TapAggIntfCli.IdentityMapDzGreMode.addCommandClass( SwitchPortToVlanMapCmd )

#--------------------------------------------------------------------------------
# policy id ( POLICY_ID | unmatched ) vlan VLAN_ID
# [ no | default ] policy id ( POLICY_ID | unmatched ) ...
#--------------------------------------------------------------------------------
class PolicyToVlanMapCmd( CliCommand.CliCommandClass ):
   syntax = 'policy id ( POLICY_ID | unmatched ) vlan VLAN_ID'
   noOrDefaultSyntax = syntax.replace( 'vlan VLAN_ID', '...' )
   data = {
      'policy' : 'Configure policy ID',
      'id' : matcherId,
      'POLICY_ID' : CliMatcher.IntegerMatcher( 1, 65535,
         helpdesc='Policy identity' ),
      'unmatched': 'Unmatched policy identity',
      'vlan' : matcherVlan,
      'VLAN_ID' : VlanCli.vlanIdMatcher,
   }
   handler = TapAggIntfCli.setDzGrePolicyToVlan
   noOrDefaultHandler = TapAggIntfCli.noDzGrePolicyToVlan

TapAggIntfCli.IdentityMapDzGreMode.addCommandClass( PolicyToVlanMapCmd )
