#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=useless-object-inheritance

import Tac
from CliPlugin import TapAggPmapModel
from CliPlugin.PolicyMapModelImpl import ActionBase
from CliPlugin.TapAggPmapCliLib import tacStripHdrType

tacTapAggActionSetAggGroup = Tac.Type( 'PolicyMap::SetAggGroup' )
tacTapAggActionSetIdentityTag = Tac.Type( 'PolicyMap::SetIdentityTag' )
tacTapAggActionStripHdrBytes = Tac.Type( 'PolicyMap::StripHeaderBytes' )
tacTapAggActionSetNexthopGroup = Tac.Type( 'PolicyMap::SetNexthopGroup' )
tacTapAggActionSetTimestampHdr = Tac.Type( 'PolicyMap::SetTimestampHeader' )
tacTapAggActionDrop = Tac.Type( 'PolicyMap::DropAction' )
tacTapAggActionSetMacAddress = Tac.Type( 'PolicyMap::SetMacAddress' )
tacTapAggActionSetHeaderRemove = Tac.Type( 'PolicyMap::SetHeaderRemove' )
tacTapAggActionSet = Tac.Type( 'PolicyMap::ActionSet' )

class TapAggGroupAction( object ):
   @classmethod
   def createModel( cls, groupVal ):
      model = TapAggPmapModel.TapAggGroupModel()
      model.actionType = groupVal.actionType
      model.aggGroup = list( groupVal.aggGroup )
      model.aggIntf = list( groupVal.aggIntf )
      return model

ActionBase.addActionType( tacTapAggActionSetAggGroup, TapAggGroupAction )

class TapAggIdTagAction( object ):
   @classmethod
   def createModel( cls, idTagVal ):
      model = TapAggPmapModel.TapAggIdTagModel()
      model.actionType = idTagVal.actionType
      model.idTag = idTagVal.idTag.outer
      model.innerIdTag = idTagVal.idTag.inner
      return model

ActionBase.addActionType( tacTapAggActionSetIdentityTag , TapAggIdTagAction )

class TapAggStripHdrAction( object ):
   @classmethod
   def createModel( cls, stripHdrVal ):
      model = TapAggPmapModel.TapAggStripHdrModel()
      model.actionType = stripHdrVal.actionType
      model.hdrType = stripHdrVal.stripHdrBytes.hdrType
      if model.hdrType == tacStripHdrType.dot1q:
         model.dot1qRemoveVlans = stripHdrVal.stripHdrBytes.dot1qRemoveVlans
      # Add handling for new header types here.
      return model

ActionBase.addActionType( tacTapAggActionStripHdrBytes, TapAggStripHdrAction )

class TapAggNexthopGroupAction( object ):
   @classmethod
   def createModel( cls, nexthopGroupVal ):
      model = TapAggPmapModel.TapAggNexthopGroupModel()
      model.actionType = nexthopGroupVal.actionType
      model.nexthopGroup = list( nexthopGroupVal.nexthopGroup )
      return model

ActionBase.addActionType( tacTapAggActionSetNexthopGroup, TapAggNexthopGroupAction )

class TapAggTimestampHeaderAction( object ):
   @classmethod
   def createModel( cls, timestampHeaderActionVal ):
      model = TapAggPmapModel.TapAggTimestampHeaderModel()
      model.actionType = timestampHeaderActionVal.actionType
      return model

ActionBase.addActionType( tacTapAggActionSetTimestampHdr,
                          TapAggTimestampHeaderAction )

class TapAggDropAction( object ):
   @classmethod
   def createModel( cls, dropActionVal ):
      model = TapAggPmapModel.TapAggDropActionModel()
      model.actionType = dropActionVal.actionType
      return model

ActionBase.addActionType( tacTapAggActionDrop, TapAggDropAction )

class TapAggMacAddressAction( object ):
   @classmethod
   def createModel( cls, macAddressActionVal ):
      model = TapAggPmapModel.TapAggMacAddressActionModel()
      model.actionType = macAddressActionVal.actionType
      model.destMac = macAddressActionVal.macAddress.destMac
      model.srcMac = macAddressActionVal.macAddress.srcMac
      return model

ActionBase.addActionType( tacTapAggActionSetMacAddress, TapAggMacAddressAction )

class TapAggHeaderRemoveAction( object ):
   @classmethod
   def createModel( cls, headerRemoveActionVal ):
      model = TapAggPmapModel.TapAggHeaderRemoveActionModel()
      model.actionType = headerRemoveActionVal.actionType
      model.size = headerRemoveActionVal.headerRemove.size
      model.preserveEth = headerRemoveActionVal.headerRemove.preserveEth
      return model

ActionBase.addActionType( tacTapAggActionSetHeaderRemove, TapAggHeaderRemoveAction )

class TapAggActionSetAction( object ):
   @classmethod
   def createModel( cls, actionSetVal ):
      model = TapAggPmapModel.TapAggActionSetModel()
      model.actionType = actionSetVal.actionType
      model.actionSet = list( actionSetVal.namedActionSet )
      return model

ActionBase.addActionType( tacTapAggActionSet, TapAggActionSetAction )
