#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Class that provides functions related to accessing the TCAM profiles
class TapAggTcamUtil():
   # Return a list of all TCAM profiles available to program
   def tcamProfileGetAll( self ):
      return []

   # Return a list of all system profiles for tap-aggregation that are guaranteed
   # to program successfully
   def tapAggSystemProfiles( self ):
      return [ 'tap-aggregation-default' ]

   # Return True if all linecards with specified profile have programmed
   # successfully, otherwise return False
   # If profileName is not specified, check all linecards
   def tcamProfileVerifyProgrammingComplete( self, profileName ):
      return True

   # Return the TCAM profile that will be set
   def defaultTcamProfileToProgram( self, tapAggEnabled=False ):
      return 'tap-aggregation-default' if tapAggEnabled else 'default'
