# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import CliCommand
import CliGlobal
import CliParser
import LazyMount

gv = CliGlobal.CliGlobal( {
   'tpmStatus': None,
} )

def guardTpm( mode, token ):
   if not gv.tpmStatus.tpmVersion:
      return CliParser.guardNotThisPlatform
   return None

tpmMatcher = CliCommand.guardedKeyword( 'tpm',
                                        helpdesc='Show TPM related information',
                                        guard=guardTpm )

def Plugin( em ):
   gv.tpmStatus = LazyMount.mount( em,
                                   Cell.path( 'hardware/tpm/status' ),
                                   'Hardware::TpmLib::Status', 'r' )
