#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Cell
import CliPlugin.TechSupportCli
import LazyMount

#-------------------------------------------------------------------------------
# Traffic Policy commands in 'show tech-support'
#-------------------------------------------------------------------------------
statusDir = None
hwStatus = None

def _trafficPolicyShowTechGuard():
   return statusDir and statusDir.get( 'cpu-vrf-hardware' )

def _trafficPolicyInterfaceShowTechGuard():
   # We support ingress traffic-policy on Strata through
   # DMF but not through the CLI. So add a guard here for
   # Strata
   if not hwStatus.ingressTrafficPolicyCliSupported:
      return False

   return ( hwStatus.ingressTrafficPolicySupported or
            hwStatus.egressTrafficPolicySupported )

def _trafficPolicyVlanShowTechGuard():
   return hwStatus.bridgedTrafficPolicySupported

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2019-02-26 11:06:03',
   cmds=[ 'show traffic-policy cpu',
          'show traffic-policy cpu errors',
          'show traffic-policy protocol neighbors bgp',
          # Use -n to prevent potentially slow DNS lookups.
          'bash sudo iptables -vnL -t mangle',
          'bash sudo ip6tables -vnL -t mangle' ],
   cmdsGuard=_trafficPolicyShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2019-12-05 13:42:17',
   cmds=[ 'show traffic-policy interface',
          'show traffic-policy interface errors' ],
   cmdsGuard=_trafficPolicyInterfaceShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2021-09-22 13:27:48',
   cmds=[ 'bash sudo conntrack -L', ],
   cmdsGuard=_trafficPolicyShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2022-01-26 15:27:59',
   cmds=[ 'show traffic-policy vlan',
          'show traffic-policy vlan errors' ],
   cmdsGuard=_trafficPolicyVlanShowTechGuard )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2024-07-09 08:02:59',
   cmds=[ 'show traffic-policy field-set integer',
          'show traffic-policy field-set ipv4 prefix',
          'show traffic-policy field-set ipv6 prefix',
          'show traffic-policy field-set l4-port',
          'show traffic-policy field-set mac',
          'show traffic-policy service',
          'show traffic-policy field-set vlan' ],
   extended='traffic-policy' )

def Plugin( entityManager ):
   global statusDir
   global hwStatus
   statusDirPath = 'cell/%d/trafficPolicies/status' % Cell.cellId()
   mountGroup = entityManager.mountGroup()
   statusDir = mountGroup.mount( statusDirPath, 'Tac::Dir', 'ri' )
   hwStatus = LazyMount.mount( entityManager,
         'trafficPolicies/hardware/status/interface',
         'TrafficPolicy::HwStatus', 'r' )
   mountGroup.close( callback=None )
