#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
from CliToken.Ip import ipMatcherForClear
from CommonGuards import ssoStandbyGuard
from CliPlugin.DecapGroupCli import (
      decapGroupSupportedGuard,
      decapGroupCountersGuard,
      clearIpDecapGroupCounters,
      mergedDgConfig,
)

matcherClear = CliCommand.guardedKeyword( 'clear',
      helpdesc='Reset functions',
      guard=ssoStandbyGuard )

matcherDecapGroup = CliCommand.guardedKeyword( 'decap-group',
      helpdesc='Decap group information',
      guard=decapGroupSupportedGuard )

matcherCounters = CliCommand.guardedKeyword( 'counters',
      helpdesc='Clear counters',
      guard=decapGroupCountersGuard )

matcherDynamic = CliMatcher.DynamicNameMatcher(
      lambda _: mergedDgConfig.decapGroup,
      helpdesc='Decap group name' )

def clearIpDecapGroupCountersHandler( mode, args ):
   nameFilter = args.get( 'DYNAMIC' ) or args.get( 'dynamic' )
   clearIpDecapGroupCounters( mode, nameFilter )

#--------------------------------------------------------------------------------
# clear ip decap-group counters [ dynamic | DYNAMIC ]
#--------------------------------------------------------------------------------
class ClearIpDecapGroupCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear ip decap-group counters [ dynamic | DYNAMIC ]'

   data = {
      'clear' : matcherClear,
      'ip' : ipMatcherForClear,
      'decap-group' : matcherDecapGroup,
      'counters' : matcherCounters,
      'dynamic' : 'Display only dynamic entries',
      'DYNAMIC' : matcherDynamic,
   }

   handler = clearIpDecapGroupCountersHandler

BasicCliModes.EnableMode.addCommandClass( ClearIpDecapGroupCountersCmd )
