# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import ConfigMount
import Tac

import Toggles.TwampToggleLib as TwampToggle

from CliPlugin.IpAddrMatcher import IpAddrMatcher
from CliPlugin.Ip6AddrMatcher import Ip6AddrMatcher
from CliPlugin.ConnectivityMonitorCli import ConnMonitorConfigHostMode
from CliPlugin.TwampConfigCli import TwampMode

twampClientCliConfig = None

AGGREGATE_HELPDESC = 'Configure TWAMP aggregate statistic settings'
SAMPLES_HELPDESC = 'Configure the number of samples to use when calculating ' + \
                   'TWAMP statistics'
LIMIT_HELPDESC = 'Configure the maximum number of aggregate data points stored'

#------------------------------------------------------------------------------------
# (config-mc-<host>)# no|default twamp <IPv4/6> [<port>]
#------------------------------------------------------------------------------------

class TwampHostCmd( CliCommand.CliCommandClass ):
   syntax = 'twamp ( IPv4 | IPv6 ) [ PORT ]'
   noOrDefaultSyntax = 'twamp ...'
   data = {
      'twamp': 'Configure connection to TWAMP server',
      'IPv4': IpAddrMatcher( helpdesc='TWAMP Server IPv4 address' ),
      'IPv6': Ip6AddrMatcher( helpdesc='TWAMP Server IPv6 address' ),
      'PORT': CliMatcher.IntegerMatcher(
         51000,
         51100,
         helpdesc='TCP port of remote TWAMP server' ) # TODO: Get user defined
      }

   @staticmethod
   def handler( mode, args ):
      pass

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      pass

#------------------------------------------------------------------------------------
# (mc-twamp)# [no|default] aggregate samples <1-65535>
#------------------------------------------------------------------------------------
class TwampAggregateSamplesCmd( CliCommand.CliCommandClass ):
   syntax = 'aggregate samples sample-size'
   noOrDefaultSyntax = 'aggregate samples ...'
   data = {
      'aggregate': AGGREGATE_HELPDESC,
      'samples': SAMPLES_HELPDESC,
      'sample-size': CliMatcher.IntegerMatcher(
         1,
         65535,
         helpdesc='Number of samples to use' )
      }

   @staticmethod
   def handler( mode, args ):
      twampClientCliConfig.aggregationWindow = args[ 'sample-size' ]

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      twampClientCliConfig.aggregationWindow = \
                                 twampClientCliConfig.aggregationWindowDefault

#------------------------------------------------------------------------------------
# (mc-twamp)# [no|default] aggregate limit <1-65535>
#------------------------------------------------------------------------------------
class TwampAggregateLimitCmd( CliCommand.CliCommandClass ):
   syntax = 'aggregate limit window-size'
   noOrDefaultSyntax = 'aggregate limit ...'
   data = {
      'aggregate': AGGREGATE_HELPDESC,
      'limit': LIMIT_HELPDESC,
      'window-size': CliMatcher.IntegerMatcher(
         1,
         65535,
         helpdesc='Number of samples to use' )
      }

   @staticmethod
   def handler( mode, args ):
      pass

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      pass

if TwampToggle.toggleTwampClientEnabled():
   ConnMonitorConfigHostMode.addCommandClass( TwampHostCmd )
   TwampMode.addCommandClass( TwampAggregateSamplesCmd )
   TwampMode.addCommandClass( TwampAggregateLimitCmd )

def Plugin( entityManager ):
   global twampClientCliConfig
   twampClientCliConfig = ConfigMount.mount(
      entityManager,
      'connectivityMonitor/twamp/client/config',
      'Twamp::Client::Config',
      'w' )
